/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.impl;

import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IMap;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.impl.CaptainsState;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javafx.geometry.Dimension2D;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Lazy
@Component
public class GameMap
implements IMap {
    @Autowired
    private CaptainsState captainsState;
    private final LinkedList<ICity> cities = new LinkedList();
    private Dimension2D dimension;
    private String mapImagePath;

    public void setup(Date date, Collection<ICity> cities, Dimension2D dim, String mapName) {
        this.dimension = dim;
        this.mapImagePath = mapName;
        for (ICity city : cities) {
            this.cities.add(city);
        }
        this.captainsState.init(this);
    }

    @Override
    public int getNumberCities() {
        return this.cities.size();
    }

    @Override
    public List<ICity> getCities() {
        return Collections.unmodifiableList(this.cities);
    }

    public void setCaptainsState(CaptainsState captainsState) {
        this.captainsState = captainsState;
    }

    @Override
    public Dimension2D getDimension() {
        return this.dimension;
    }

    @Override
    public String getMapImagePath() {
        return this.mapImagePath;
    }
}

