/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IUpdateableState;
import ch.sahits.game.openpatrician.model.people.IBuyer;
import ch.sahits.game.openpatrician.model.people.impl.BaseTavernPerson;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import java.util.Random;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
public class BuyerState
extends BaseTavernPerson
implements IBuyer,
IUpdateableState {
    @Autowired
    private Random rnd;
    @Autowired
    private Date date;
    private String name;
    private DateTime deadline;
    private IWare ware;
    private AmountablePrice<IWare> amountablePrice;
    private static RandomNameLoader firstNameLoader = new RandomNameLoader("firstnames.properties");
    private static RandomNameLoader lastNameLoader = new RandomNameLoader("lastnames.properties");

    @Override
    public DateTime getTimeFrame() {
        return this.deadline;
    }

    @Override
    public void update() {
        this.setName(firstNameLoader.getRandomName() + " " + lastNameLoader.getRandomName());
        int days = this.rnd.nextInt(5);
        this.setDeadline(this.date.getCurrentDate().plusDays(5 + days));
        int wareIndex = this.rnd.nextInt(EWare.values().length);
        EWare ware = EWare.values()[wareIndex];
        this.setWare(ware);
        int amount = this.rnd.nextInt(21) + 3;
        int price = ware.computeBuyPrice(5, amount);
        AmountablePrice<IWare> amt = new AmountablePrice<IWare>();
        amt.add(amount, price);
        this.setAmountablePrice(amt);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDeadline(DateTime deadline) {
        this.deadline = deadline;
    }

    @Override
    public IWare getWare() {
        return this.ware;
    }

    public void setWare(IWare ware) {
        this.ware = ware;
    }

    public void setAmountablePrice(AmountablePrice<IWare> amountablePrice) {
        this.amountablePrice = amountablePrice;
    }

    @Override
    public AmountablePrice<IWare> getAmountablePrice() {
        return this.amountablePrice;
    }
}

