/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IMap;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.people.PeopleFactory;
import ch.sahits.game.openpatrician.model.people.impl.CaptainTownMapping;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CaptainsState {
    @Autowired
    private Random rnd;
    @Value(value="${freeCaptain.max}")
    private int maxFreeCaptains;
    @Value(value="${freeCaptain.timeInTown}")
    private int maxTimeInTown;
    @Autowired
    private PeopleFactory peopleFactory;
    private IMap map;
    @Autowired
    private Date date;
    private List<CaptainTownMapping> captainMapping = Lists.newArrayList();

    public void init(IMap map) {
        this.map = map;
        for (int i = 0; i < this.maxFreeCaptains; ++i) {
            ICity city = this.getRandomCity();
            DateTime currentDate = this.date.getCurrentDate();
            double nextGaussian = this.rnd.nextDouble();
            DateTime arrival = currentDate.minus((long)((int)Math.rint(nextGaussian * (double)this.maxTimeInTown)));
            ICaptain captain = this.peopleFactory.createNewCaptainProperty();
            this.captainMapping.add(new CaptainTownMapping(city, arrival, captain));
        }
    }

    private ICity getRandomCity() {
        List<ICity> cities = this.map.getCities();
        return cities.get(this.rnd.nextInt(cities.size()));
    }

    public Optional<ICaptain> getCaptain(ICity city) {
        for (CaptainTownMapping mapped : this.captainMapping) {
            if (!mapped.getTown().equals(city)) continue;
            return Optional.of((Object)mapped.getCaptain());
        }
        return Optional.absent();
    }

    public void hireCaptain(ICaptain captain, ICity city) {
        Iterator<CaptainTownMapping> iterator = this.captainMapping.iterator();
        while (iterator.hasNext()) {
            CaptainTownMapping mapped = iterator.next();
            if (!mapped.getTown().equals(city) || !mapped.getCaptain().equals(captain)) continue;
            iterator.remove();
            break;
        }
    }
}

