/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IUpdatableCityRelatedState;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.IPatrol;
import ch.sahits.game.openpatrician.model.people.impl.BasePatrolState;
import ch.sahits.game.openpatrician.model.util.CityUtilities;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import java.util.ArrayList;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
public class PatrolState
extends BasePatrolState
implements IPatrol,
IUpdatableCityRelatedState {
    @Autowired
    private Random rnd;
    @Autowired
    private CityUtilities cityUtils;
    private int premium;
    private int bonus;
    private static RandomNameLoader firstNameLoader = new RandomNameLoader("firstnames.properties");
    private static RandomNameLoader lastNameLoader = new RandomNameLoader("lastnames.properties");

    public PatrolState() {
        this.destinations = new ICity[3];
    }

    @Override
    public void update(ICity startCity) {
        this.setName(firstNameLoader.getRandomName() + " " + lastNameLoader.getRandomName());
        this.setPremium(this.rnd.nextInt(2000) + 4300);
        this.setBonus(this.rnd.nextInt(2000) + 2000);
        this.updateDestinations(startCity, 3);
    }

    private void updateDestinations(ICity startCity, int nbDestinations) {
        ArrayList<ICity> visited = new ArrayList<ICity>();
        visited.add(startCity);
        ICity curCity = startCity;
        for (int i = 0; i < nbDestinations; ++i) {
            ICity next;
            this.destinations[i] = next = this.cityUtils.findNearbyCityRepeated(curCity, 0.2, 1024, visited);
            visited.add(next);
            curCity = next;
        }
        this.currentDestIndex = 0;
    }

    @Override
    public int getPremium() {
        return this.premium;
    }

    public void setPremium(int premium) {
        this.premium = premium;
    }

    @Override
    public int getBonus() {
        return this.bonus;
    }

    public void setBonus(int bonus) {
        this.bonus = bonus;
    }
}

