/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IUpdateableState;
import ch.sahits.game.openpatrician.model.people.IWarehouseTenant;
import ch.sahits.game.openpatrician.model.people.impl.BaseTavernPerson;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
public class WarehouseTenant
extends BaseTavernPerson
implements IWarehouseTenant,
IUpdateableState {
    @Autowired
    private Random rnd;
    private static RandomNameLoader firstNameLoader = new RandomNameLoader("firstnames.properties");
    private static RandomNameLoader lastNameLoader = new RandomNameLoader("lastnames.properties");
    private String name;
    private int amount;

    @Override
    public int getRentPerWeek() {
        return 5 * this.amount;
    }

    @Override
    public void update() {
        this.setName(firstNameLoader.getRandomName() + " " + lastNameLoader.getRandomName());
        this.setAmount(this.rnd.nextInt(800) + 100);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    private void setAmount(int amount) {
        this.amount = amount;
    }
}

