/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.people.IWeaponsDealer;
import ch.sahits.game.openpatrician.model.product.ETransferAmount;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import ch.sahits.game.openpatrician.util.TransferUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javafx.beans.Observable;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@Prototype
public class WeaponsDealerState
implements IWeaponsDealer {
    @Autowired
    private Random rnd;
    @Value(value="${tavern.weapons.dealer.sellvalue.factor}")
    private double sellValue;
    @Autowired
    private TransferUtil transferUtil;
    private Map<IWeapon, IntegerProperty> weaponStore = new HashMap<IWeapon, IntegerProperty>();

    @PostConstruct
    public void init() {
        this.addNewWare(EWeapon.SWORD, this.rnd.nextInt(5));
        this.addNewWare(EWeapon.BOW, this.rnd.nextInt(5));
        this.addNewWare(EWeapon.CROSSBOW, this.rnd.nextInt(5));
        this.addNewWare(EWeapon.MUSKET, this.rnd.nextInt(5));
    }

    @Override
    public IntegerBinding buyPriceBinding(final ObjectProperty<ETransferAmount> amount, final EWeapon weapon) {
        return new IntegerBinding(){
            {
                super.bind(new Observable[]{(Observable)WeaponsDealerState.this.weaponStore.get(weapon), amount});
            }

            protected int computeValue() {
                int availableAmount = WeaponsDealerState.this.getWeapon(weapon);
                int buyAmount = WeaponsDealerState.this.transferUtil.calculateAvailableAmount((ObjectProperty<ETransferAmount>)amount, availableAmount);
                if (buyAmount > 0) {
                    return weapon.computeBuyPrice(availableAmount, buyAmount);
                }
                return 0;
            }
        };
    }

    @Override
    public IntegerBinding sellPriceBinding(final EWeapon weapon, final IntegerBinding amountToSell) {
        return new IntegerBinding(){
            {
                super.bind(new Observable[]{(Observable)WeaponsDealerState.this.weaponStore.get(weapon), amountToSell});
            }

            protected int computeValue() {
                if (amountToSell.get() > 0) {
                    int availableAmount = WeaponsDealerState.this.getWeapon(weapon);
                    return weapon.computeSellPrice(availableAmount, amountToSell.get());
                }
                return 0;
            }
        };
    }

    private void addNewWare(IWeapon weapon, int amount) {
        this.weaponStore.put(weapon, (IntegerProperty)new SimpleIntegerProperty(amount));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int move(IWeapon weapon, int amount) {
        IWeapon iWeapon = weapon;
        synchronized (iWeapon) {
            int amounted = this.getWeapon(weapon);
            if (amount < 0 && this.containsWare(weapon) && -amount > amounted) {
                amount = -amounted;
            }
            if (amount < 0 && !this.containsWare(weapon)) {
                amount = 0;
            }
            this.weaponStore.get(weapon).set(amounted + amount);
            return amount;
        }
    }

    protected final boolean containsWare(IWeapon weapons) {
        return this.weaponStore.containsKey(weapons) && this.weaponStore.get(weapons).get() > 0;
    }

    private int getWeapon(IWeapon weapon) {
        return this.weaponStore.get(weapon).get();
    }

    @Override
    public IntegerProperty amountAvailableProperty(EWeapon weapon) {
        return this.weaponStore.get(weapon);
    }
}

