/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.product;

import ch.sahits.game.openpatrician.model.product.IPriceCalculation;
import ch.sahits.game.openpatrician.model.product.SimplePriceCalculation;
import com.google.common.base.Preconditions;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerPropertyBase;

public class ComputablePrice {
    private final IPriceCalculation calculation = new SimplePriceCalculation();
    private final ReadOnlyIntegerProperty maxValueBuy;
    private final ReadOnlyIntegerProperty minValueBuy;
    private final ReadOnlyIntegerProperty maxValueSell;
    private final ReadOnlyIntegerProperty minValueSell;
    private final ReadOnlyIntegerProperty saturation;
    private final String name;

    public ComputablePrice(final int maxValueBuy, final int minValueBuy, final int maxValueSell, final int minValueSell, final int saturation, String name) {
        this.maxValueBuy = new ReadOnlyIntegerPropertyBase(){

            public Object getBean() {
                return ComputablePrice.this;
            }

            public String getName() {
                return "maxValueBuy";
            }

            public int get() {
                return maxValueBuy;
            }
        };
        this.minValueBuy = new ReadOnlyIntegerPropertyBase(){

            public Object getBean() {
                return ComputablePrice.this;
            }

            public String getName() {
                return "minValueBuy";
            }

            public int get() {
                return minValueBuy;
            }
        };
        this.maxValueSell = new ReadOnlyIntegerPropertyBase(){

            public Object getBean() {
                return ComputablePrice.this;
            }

            public String getName() {
                return "maxValueSell";
            }

            public int get() {
                return maxValueSell;
            }
        };
        this.minValueSell = new ReadOnlyIntegerPropertyBase(){

            public Object getBean() {
                return ComputablePrice.this;
            }

            public String getName() {
                return "minValueSell";
            }

            public int get() {
                return minValueSell;
            }
        };
        this.saturation = new ReadOnlyIntegerPropertyBase(){

            public Object getBean() {
                return ComputablePrice.this;
            }

            public String getName() {
                return "saturation";
            }

            public int get() {
                return saturation;
            }
        };
        this.name = name;
    }

    public int getMaxValueBuy() {
        return this.maxValueBuy.get();
    }

    public ReadOnlyIntegerProperty maxValueBuyProperty() {
        return this.maxValueBuy;
    }

    public int getMaxValueSell() {
        return this.maxValueSell.get();
    }

    public ReadOnlyIntegerProperty maxValueSellProperty() {
        return this.maxValueSell;
    }

    public int getMinValueSell() {
        return this.minValueSell.get();
    }

    public ReadOnlyIntegerProperty minValueSell() {
        return this.minValueSell;
    }

    public int getMinValueBuy() {
        return this.minValueBuy.get();
    }

    public ReadOnlyIntegerProperty minValueBuy() {
        return this.minValueBuy;
    }

    public int getMarketSaturation() {
        return this.saturation.get();
    }

    public ReadOnlyIntegerProperty marketSaturationProperty() {
        return this.saturation;
    }

    @Deprecated
    public int computeSellPrice(int availableAmount, int amountToSell) {
        return this.internalSellPriceCalculation(availableAmount, amountToSell);
    }

    int internalSellPriceCalculation(int availableAmount, int amountToSell) {
        Preconditions.checkArgument((amountToSell > 0 ? 1 : 0) != 0, (Object)("The amount to sell must be larger than 0 (was " + availableAmount + ") for " + this.name));
        Preconditions.checkArgument((availableAmount >= 0 ? 1 : 0) != 0, (Object)("The available amount must be positive for " + this.name));
        if (availableAmount >= this.getMarketSaturation()) {
            return this.getMinValueSell();
        }
        int min = this.getMinValueSell();
        int max = this.getMaxValueSell();
        int firstItemPrice = (int)Math.rint(this.calculation.computePrice(min, max, availableAmount, this.getMarketSaturation(), 0, null, null));
        if (amountToSell > 1) {
            int lastItemPrice = (int)Math.rint(this.calculation.computePrice(min, max, availableAmount + amountToSell, this.getMarketSaturation(), 0, null, null));
            return (int)Math.rint((double)(firstItemPrice + lastItemPrice) / 2.0);
        }
        return firstItemPrice;
    }

    @Deprecated
    public int computeBuyPrice(int availableAmount, int amountToBuy) {
        return this.internalBuyPriceCalculation(availableAmount, amountToBuy);
    }

    int internalBuyPriceCalculation(int availableAmount, int amountToBuy) {
        Preconditions.checkArgument((amountToBuy > 0 ? 1 : 0) != 0, (Object)("The amount to buy must be larger than 0 for " + this.name));
        Preconditions.checkArgument((availableAmount >= 0 ? 1 : 0) != 0, (Object)("The available amount must be positive for " + this.name));
        if (availableAmount == 0) {
            return 0;
        }
        if (availableAmount >= this.getMarketSaturation()) {
            return this.getMinValueBuy();
        }
        int min = this.getMinValueBuy();
        int max = this.getMaxValueBuy();
        int firstItemPrice = (int)Math.rint(this.calculation.computePrice(min, max, availableAmount, this.getMarketSaturation(), 0, null, null));
        if (amountToBuy > 1) {
            int lastItemPrice = (int)Math.rint(this.calculation.computePrice(min, max, availableAmount - amountToBuy, this.getMarketSaturation(), 0, null, null));
            return (int)Math.rint((double)(firstItemPrice + lastItemPrice) / 2.0);
        }
        return firstItemPrice;
    }

    public int buyPrice(IntegerProperty availableAmount, IntegerBinding amountToBuy) {
        return this.internalBuyPriceCalculation(availableAmount.get(), amountToBuy.get());
    }

    public int sellPrice(IntegerProperty availableAmount, IntegerBinding amountToSell) {
        return this.internalSellPriceCalculation(availableAmount.get(), amountToSell.get());
    }
}

