/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.time;

import ch.sahits.game.event.data.ClockTick;
import ch.sahits.game.event.data.ClockTickIntervalChange;
import ch.sahits.game.event.data.PeriodicalTimeDayUpdate;
import ch.sahits.game.event.data.PeriodicalTimeMonthUpdate;
import ch.sahits.game.event.data.PeriodicalTimeWeekUpdate;
import ch.sahits.game.event.data.PeriodicalTimeYearUpdate;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.time.EUpdateIntervalRegistration;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class PeriodicalTimeUpdaterV2 {
    private int tickInterval;
    @Autowired
    private Date date;
    private int updateInterval;
    private final EUpdateIntervalRegistration intervall;
    private int timePassed = 0;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;

    public PeriodicalTimeUpdaterV2(EUpdateIntervalRegistration intervall) {
        Preconditions.checkArgument((intervall != EUpdateIntervalRegistration.DAILY ? 1 : 0) != 0, (Object)"This updater does not handle daily events");
        this.intervall = intervall;
        System.out.println("Create periodical updater for intervall " + (Object)((Object)intervall));
    }

    @PostConstruct
    public void initializeEventBus() {
        this.tickInterval = this.date.getTickUpdate();
        DateTime cal = this.date.getCurrentDate();
        switch (this.intervall) {
            case YEAR: {
                this.updateInterval = 525600;
                this.timePassed = (cal.getYear() - 1) * 24 * 60;
                this.timePassed += cal.getHourOfDay() * 60;
                this.timePassed += cal.getMinuteOfDay();
                break;
            }
            case MONTH: {
                this.updateInterval = 43200;
                this.timePassed = (cal.getDayOfMonth() - 1) * 24 * 60;
                this.timePassed += cal.getHourOfDay() * 60;
                this.timePassed += cal.getMinuteOfDay();
                break;
            }
            case WEEK: {
                this.updateInterval = 10080;
                this.timePassed = cal.getDayOfWeek() * 24 * 60;
                this.timePassed += cal.getHourOfDay() * 60;
                this.timePassed += cal.getMinuteOfDay();
                break;
            }
            case END_OF_DAY: {
                this.updateInterval = 1440;
                this.timePassed += cal.getHourOfDay() * 60;
                this.timePassed += cal.getMinuteOfDay();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown update interval: " + (Object)((Object)this.intervall));
            }
        }
        this.clientServerEventBus.register((Object)this);
    }

    @Subscribe
    public void updateTick(ClockTickIntervalChange event) {
        this.tickInterval = event.getInterval();
    }

    @Subscribe
    public void handleClockTick(ClockTick event) {
        this.timePassed += this.tickInterval;
        if (this.timePassed > this.updateInterval) {
            switch (this.intervall) {
                case YEAR: {
                    this.clientServerEventBus.post((Object)new PeriodicalTimeYearUpdate());
                    break;
                }
                case MONTH: {
                    this.clientServerEventBus.post((Object)new PeriodicalTimeMonthUpdate());
                    break;
                }
                case WEEK: {
                    this.clientServerEventBus.post((Object)new PeriodicalTimeWeekUpdate());
                    break;
                }
                case END_OF_DAY: {
                    this.clientServerEventBus.post((Object)new PeriodicalTimeDayUpdate());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown update interval: " + (Object)((Object)this.intervall));
                }
            }
            this.timePassed = 0;
        }
    }

    public void unregisterFromEventBus() {
        this.clientServerEventBus.unregister((Object)this);
    }
}

