package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.model.city.ICity;


/**
 * Interface defining the update functionality of a state, which
 * requires a reference to a city for updating.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 30, 2013
 *
 */
public interface IUpdatableCityRelatedState {
	/**
	 * Update the state by using the referenced city.
	 * @param city that should be updated.
	 */
	void update(ICity city);
}
