package ch.sahits.game.openpatrician.model.city.cityhall;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.model.ICitizen;

import java.util.ArrayList;
import java.util.List;

/**
 * Holds a list of elderman candidates.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Aug 27, 2015
 */
@LazySingleton
@ClassCategory({EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class EldermanCandidateList {
    @ListType(ICitizen.class)
    private ArrayList<ICitizen> eldermanCandidates = new ArrayList<>();

    public int size() {
        return eldermanCandidates.size();
    }

    public ICitizen get(int index) {
        return eldermanCandidates.get(index);
    }

    public boolean add(ICitizen iCitizen) {
        return eldermanCandidates.add(iCitizen);
    }

    public List<ICitizen> getAll() {
        return eldermanCandidates;
    }
}
