package ch.sahits.game.openpatrician.model.city.cityhall;

import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.city.ICity;
import java.util.Optional;
import javafx.collections.ObservableList;
import org.joda.time.DateTime;

import java.util.List;

/**
 * Representing the state of the various issues that may be addressed
 * at the city hall.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 31, 2014
 */
public interface ICityHall {
    /**
     * Retrieve the list of notices for wares that can be delivered
     * to other cities at a guaranteed price. These notices get updated
     * on a weekly basis.
     * @return
     */
    ObservableList<ICityHallNotice> getNotices();

    /**
     * Current outrigger of the city. As the city may not have an outrigger
     * assigned it may be absent.
     * @return
     */
    Optional<IOutriggerContract> getOutriggerContract();

    /**
     * Set the outrigger contract.
     * @param contract
     */
    void setOutriggerContract(Optional<IOutriggerContract> contract);

    /**
     * Current mayor of the city
     * @return
     */
    ICitizen getMayor();

    /**
     * Date of the next election. Elections happen all 2 years.
     * @return
     */
    DateTime getElectionDate();

    /**
     * Retrieve the list of candidates for the next election.
     * @return
     */
    List<ICitizen> getCandidates();

    /**
     * Date of the next council meeting to discuss a petition.
     * @return
     */
    Optional<DateTime> getNextCouncilMeeting();

    /**
     * Petition to be discussed at the next council meeting.
     * @return
     */
    Optional<ICityPetition> getPetition();

    /**
     * Set the petition.
     * @param petition
     */
    void setPetition(Optional<ICityPetition> petition);

    /**
     * Retrieve the elderman.
     * @return
     */
    ICitizen getElderman();

    /**
     * Date of the next elderman election.
     * @return
     */
    DateTime getEldermanElectionDate();

    /**
     * Retrieve the top four of the candidates for the elderman post.
     * @return
     */
    EldermanCandidateList getEldermanCandidates();

    /**
     * Retrieve the treasury.
     * @return
     */
    ITreasury getTreasury();

    /**
     * Retrieve the city guard.
     * @return
     */
    List<ICityGuard> getCityGuard();

    /**
     * Retrieve the office of the elderman. This office is
     * only available if the elderman resides in the currenct city.
     * @return
     */
    Optional<IEldermanOffice> getEldermanOffice();

    /**
     * Retrieve the city belonging to this city hall
     * @return
     */
    ICity getCity();


    /**
     * Retrieve the list of all councilmen of the city
     * @return
     */
    List<ICitizen> getCouncilmen();
    /**
     * Retrieve the meeting date for the next extra circular hanseatic day.
     * @return
     */
    Optional<DateTime> getHanseaticMeetingDate();

    Optional<IElectionResult> getElectionResult();
    Optional<IBallot> getBallotResult();

    /**
     * Retrieve the maximum allowed members of the guard.
     * @return
     */
    int getMaxNumberMilita();

}
