package ch.sahits.game.openpatrician.model.city.cityhall;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.IContractBroker;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;
import org.joda.time.DateTime;

/**
 * Notice on the board in the city hall for delivering wares to other cities fo a fixed price.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 31, 2014
 */
public interface ICityHallNotice {
    /**
     * Whom to contact in the destination city for delivery.
     * @return
     */
    IContractBroker getContact();

    /**
     * What ware is required.
     * @return
     */
    IWare getRequiredWare();

    /**
     * Destination to deliver the ware to.
     * @return
     */
    ICity getDestination();

    /**
     * Required amount and their guaranteed price.
     * @return
     */
    AmountablePrice<IWare> getWareAndAmount();

    /**
     * Time untill when the ware has to be delivered.
     * @return
     */
    DateTime getDueDate();

}
