package ch.sahits.game.openpatrician.model.city.cityhall;

import ch.sahits.game.openpatrician.model.city.ICity;
import org.joda.time.DateTime;

/**
 * Violation of a city against the hanseatic customs.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 31, 2014
 */
public interface ICityViolation {
    /**
     * City that violated the customs.
     * @return
     */
    ICity getCity();

    /**
     * Date when the violation was brought to the notice of the elderman.
     * @return
     */
    DateTime getDate();

    /**
     * Retrieve the proposed punishment for the violation.
     * @return
     */
    ECityViolationPunishment getPunishment();
}
