package ch.sahits.game.openpatrician.model.city.cityhall;

import ch.sahits.game.openpatrician.model.IPlayer;
import java.util.Optional;
import org.joda.time.DateTime;

import java.util.List;

/**
 * Office of the elderman. The elderman can order hanseatic days or
 * a player can take a task to fulfill should he have sufficient reputation.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 31, 2014
 */
public interface IEldermanOffice {
    /**
     * Retrieve the list of available tasks.
     * @return
     */
    List<IEldermanTask> getTasks();

    /**
     * Get the current violation. As there might be non this might be absent.
     * @return
     */
    Optional<ICityViolation> getViolation();



    /**
     * Monthly check if there should be new tasks or violations added.
     */
    void update();

    /**
     * Add a new task that is currently worked on.
     * @param limit time limit until when the task has to be completed
     * @param task that is to be fullfiled.
     * @param player who is working on the task
     */
    void addTask(IEldermanTask task, DateTime limit, IPlayer player);

    /**
     * Task is finished, so remove it from the list.
     * @param task completed task
     */
    void finished(IEldermanTask task);

    /**
     * Retrieve the tasks that are currently worked on.
     * @return
     */
    List<IAcceptedEldermanTask> getWorkedOnTasks();
}
