package ch.sahits.game.openpatrician.model.city.cityhall.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.cityhall.IBuildLandPassage;
import lombok.Getter;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 31, 2014
 */
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
@Prototype
public class BuildLandPassage extends EldermanTask implements IBuildLandPassage {
    @Getter
    private final ICity fromCity;
    @Getter
    private final ICity toCity;

    public BuildLandPassage(int duration, ICity fromCity, ICity toCity) {
        super(duration);
        this.fromCity = fromCity;
        this.toCity = toCity;
    }
}
