package ch.sahits.game.openpatrician.model.city.cityhall.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.MapSegmentedImage;
import ch.sahits.game.openpatrician.model.city.cityhall.ICapturePirateNest;
import javafx.geometry.Point2D;
import lombok.Getter;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 31, 2014
 */
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
@Prototype
public class CapturePirateNest extends EldermanTask implements ICapturePirateNest {
    @Getter
    private final Point2D location;
    @Getter
    private final MapSegmentedImage pirateNestMap;

    public CapturePirateNest(int duration, Point2D location, MapSegmentedImage pirateNestMap) {
        super(duration);
        this.location = location;
        this.pirateNestMap = pirateNestMap;
    }
}
