package ch.sahits.game.openpatrician.model.city.cityhall.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.annotation.OptionalType;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.cityhall.IAcceptedEldermanTask;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.IEldermanOffice;
import ch.sahits.game.openpatrician.model.city.cityhall.IEldermanTask;
import java.util.Optional;
import javafx.collections.ObservableList;
import lombok.Getter;
import lombok.Setter;
import org.joda.time.DateTime;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 31, 2014
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class EldermanOffice implements IEldermanOffice {
    @Getter
    @ListType(IEldermanTask.class)
    private final ObservableList<IEldermanTask> tasks;
    @Getter
    @Setter
    @OptionalType(ICityViolation.class)
    private Optional<ICityViolation> violation = Optional.empty();
    @Getter
    @ListType(IAcceptedEldermanTask.class)
    private List<IAcceptedEldermanTask> workedOnTasks = new ArrayList<>();


    public EldermanOffice(ObservableList<IEldermanTask> tasks) {
        this.tasks = tasks;
    }

    @Override
    public void update() {
        // todo: andi 12/31/14: implement
    }
    public void addTask(IEldermanTask task, DateTime limit, IPlayer player) {
        workedOnTasks.add(new AcceptedEldermanTask(task, limit, player));
    }
    public void finished(IEldermanTask task) {
        for (Iterator<IAcceptedEldermanTask> iterator = workedOnTasks.iterator(); iterator.hasNext(); ) {
            IAcceptedEldermanTask next = iterator.next();
            if (task.equals(next.getTask())) {
                iterator.remove();
                break;
            }
        }
    }

}
