package ch.sahits.game.openpatrician.model.city.cityhall.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.city.cityhall.IElectionResult;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Apr 06, 2015
 */
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public class Election implements IElectionResult {
    @Getter
    private final boolean mayoral;
    @Getter
    @MapType(key = ICitizen.class, value = Integer.class)
    private Map<ICitizen, Integer> votes = new HashMap<>();

    public Election(boolean mayoral) {
        this.mayoral = mayoral;
    }

    @Override
    public void vote(ICitizen citizen) {
        if (votes.containsKey(citizen)) {
            votes.put(citizen, votes.get(citizen) + 1);
        } else {
            votes.put(citizen, 1);
        }
    }
}
