package ch.sahits.game.openpatrician.model.city.cityhall.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.city.cityhall.IFoundNewSettlement;
import javafx.geometry.Point2D;
import lombok.Getter;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 31, 2014
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class FoundNewSettlement extends EldermanTask implements IFoundNewSettlement {
    @Getter
    private final Point2D location;
    @Getter
    private final String name;

    public FoundNewSettlement(int duration, Point2D location, String name) {
        super(duration);
        this.location = location;
        this.name = name;
    }
}
