package ch.sahits.game.openpatrician.model.city.cityhall.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.city.cityhall.ITreasury;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleLongProperty;
import lombok.Getter;
import lombok.experimental.Builder;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 31, 2014
 */
@Builder
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public class Treasury implements ITreasury {
    @Getter
    private double currentHeadTaxValue = 4;
    @Getter
    private double currentPropertyTax = 280;
    @Getter
    private long paidTaxes = 0;
    @Getter
    private long paidSpecialTaxes = 0;
    @Getter
    private int cityGuardCosts = 0;
    @Getter
    private int buildingCosts = 0;
    @Getter
    private int outriggerCosts = 0;
    @Getter
    private int siegeCosts = 0;
    @Getter
    private int otherCosts = 0;
    @Getter
    private int otherIncome = 0;
    @Getter
    private int donations = 0;
    private LongProperty cash = new SimpleLongProperty(0);



    /**
     * Reset all the moneytary values save cash back to 0.
      */
    public void reset() {
       paidTaxes = 0;
        paidSpecialTaxes = 0;
        cityGuardCosts = 0;
        buildingCosts = 0;
        outriggerCosts = 0;
        siegeCosts = 0;
        otherIncome = 0;
        otherCosts = 0;
        donations = 0;
    }

    public void setCurrentHeadTaxValue(double currentHeadTaxValue) {
        this.currentHeadTaxValue = currentHeadTaxValue;
    }

    public void setCurrentPropertyTax(double currentPropertyTax) {
        this.currentPropertyTax = currentPropertyTax;
    }

    public void addPaidTaxes(long paidTaxes) {
        this.paidTaxes += paidTaxes;
        cash.setValue(cash.get() + paidTaxes);
    }

    public void addPaidSpecialTaxes(long paidSpecialTaxes) {
        this.paidSpecialTaxes += paidSpecialTaxes;
        cash.setValue(cash.get() + paidSpecialTaxes);
    }

    public void subtractCityGuardCosts(int cityGuardCosts) {
        this.cityGuardCosts -= cityGuardCosts;
        cash.setValue(cash.get() - cityGuardCosts);
    }

    public void subtractBuildingCosts(int buildingCosts) {
        this.buildingCosts -= buildingCosts;
        cash.setValue(cash.get() - buildingCosts);

    }

    public void subtractOutriggerCosts(int outriggerCosts) {
        this.outriggerCosts -= outriggerCosts;
        cash.setValue(cash.get() - outriggerCosts);
    }

    public void subtractSiegeCosts(int siegeCosts) {
        this.siegeCosts -= siegeCosts;
        cash.setValue(cash.get() - siegeCosts);
    }

    public void subtractOtherCosts(int otherCosts) {
        this.otherCosts -= otherCosts;
        cash.setValue(cash.get() - otherCosts);
    }

    public void addOtherIncome(int otherIncome) {
        this.otherIncome += otherIncome;
        cash.setValue(cash.get() + otherIncome);
    }

    public void addDonations(int donations) {
        this.donations += donations;
        cash.setValue(cash.get() + donations);
    }

    @Override
    public long getCash() {
        return cash.get();
    }

    public LongProperty cashProperty() {
        return cash;
    }

    public void setCash(long cash) {
        this.cash.set(cash);
    }

}
