package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.MultimapType;
import ch.sahits.game.openpatrician.annotation.UniquePrototype;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.product.IWare;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Iterator;

/**
 * Tracking the contibutions of ware over the last seven days rolling.
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 24, 2012
 *
 */
@UniquePrototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
public class Contributions {

	@Autowired
	private Date date;
	@MultimapType(key=IWare.class, value = Contribution.class)
	private Multimap<IWare, Contribution> contributions = ArrayListMultimap.create();


	/**
	 * Retrieve the contribution for the whole week
	 * @param ware
	 * @return
	 */
	public int getContribution(IWare ware){
		int sum = 0;
		DateTime lastWeek = date.getCurrentDate().minusDays(7);
		for (Iterator<Contribution> iterator = contributions.get(ware).iterator(); iterator.hasNext(); ) {
			Contribution contrib = iterator.next();

			if (contrib.getTimestamp().isBefore(lastWeek)) {
				iterator.remove();
			} else {
				sum += contrib.getAmount();
			}
		}
		return sum;
	}
	/**
	 * Contribute the amount of the ware. the amount may be possitive or negative
	 * @param ware
	 * @param amount
	 */
	public void contribute(IWare ware,int amount){
		DateTime now = date.getCurrentDate();
		DateTime lastWeek = date.getCurrentDate().minusDays(7);
		if (contributions.containsKey(ware)) {
			for (Iterator<Contribution> iterator = contributions.get(ware).iterator(); iterator.hasNext(); ) {
				Contribution contrib = iterator.next();
				if (contrib.getTimestamp().isBefore(lastWeek)) {
					iterator.remove();
				}
			}
		}
		contributions.put(ware, new Contribution(now, amount, ware));
	}
}
