package ch.sahits.game.openpatrician.model.event;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IPlayer;
import lombok.Getter;

/**
 * Container for delivering display messages from one player to another.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Nov 15, 2014
 */
@Getter
@ClassCategory(EClassCategory.EVENT_OBJECT)
public class DisplayMessagePackage {
    private final IPlayer source;
    private final IPlayer target;
    private final DisplayMessage message;

    public DisplayMessagePackage(IPlayer source, IPlayer target, DisplayMessage message) {
        this.source = source;
        this.target = target;
        this.message = message;
    }
}
