package ch.sahits.game.openpatrician.model.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.UniquePrototype;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.Difficulty;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.EGameSpeed;
import ch.sahits.game.openpatrician.model.EObjective;
import ch.sahits.game.openpatrician.model.IGame;
import ch.sahits.game.openpatrician.model.IMap;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import lombok.Getter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.xml.bind.annotation.XmlElement;

/**
 * Implementation of the game
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Sep 16, 2011
 *
 */
@UniquePrototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
public class Game implements IGame {
	@Getter
	@Autowired
	private IMap map;
	@SuppressWarnings("unused")
	private final EObjective objective;
    @Getter
	private final Difficulty difficulty;
	@Getter
    private EGameSpeed gameSpeed;   // fixme: andi 9/6/15: make this an observable object
	private boolean fastforward = false;
	@Getter
	@Autowired
    private Date time;

	private boolean singleplayer;
	@Autowired
	@Qualifier("clientEventBus")
	@XStreamOmitField
	private AsyncEventBus clientEventBus;

	@XmlElement
	private static boolean constructed = false;

	
	public Game(EObjective objective,
			Difficulty difficulty, EGameSpeed speed, boolean singleplayer) {
		Preconditions.checkState(!constructed, "The game may only be instantiated once.");
		this.objective = objective;
		this.difficulty = difficulty;
		this.gameSpeed = speed;
		this.singleplayer = singleplayer;
		constructed = true;
	}
	@PostConstruct
	private void init() {
		clientEventBus.register(this);
		setupGamespeed();
	}

	private void setupGamespeed() {
		switch (gameSpeed) {
			case BREAK:
				time.setTickUpdate(0);
				break;
			case SLOW:
				time.setTickUpdate(5);
				break;
			case MEDIUM:
				time.setTickUpdate(30);
				break;
			case FAST:
				time.setTickUpdate(60);
		}
	}

	@PreDestroy
	private void unregister() {
		clientEventBus.unregister(this);
	}

	public void setGameSpeed(EGameSpeed speed) {
		this.gameSpeed = speed;
		setupGamespeed();
	}
	@Subscribe
	public void handleMessage(DisplayMessage message) {
		normalSpeed();
	}

	private void normalSpeed() {
		if (fastforward) {
			init();
			fastforward = false;
			System.out.println("Fall back to normal speed: "+gameSpeed);
		}
	}

	@Override
	public void fastForward() {
		 if (gameSpeed != EGameSpeed.FAST) {
			 if (fastforward) {
				normalSpeed();
			 } else {
				 time.setTickUpdate(60);
				 fastforward = true;
				 System.out.println("Move to fast forward");
			 }
		 }
	}



	@Override
	public boolean isObjectivReached() {
		// TODO Auto-generated method stub
		return false;
	}

}
