package ch.sahits.game.openpatrician.model.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.ILandBridge;
import ch.sahits.game.openpatrician.model.IMap;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.IFutureTowns;
import ch.sahits.game.openpatrician.model.people.impl.CaptainsState;
import ch.sahits.game.openpatrician.model.sea.PirateNest;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import javafx.geometry.Dimension2D;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
/**
 * Implementation of the game map.
 * This singleton is instaniated by the Game Factory.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Sep 16, 2011
 *
 */
@Component
@Lazy
@DependentInitialisation(StartNewGameBean.class)
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
public class GameMap implements IMap {
    @ListType(ICity.class)
	private final LinkedList<ICity> cities = new LinkedList<>();
    @Autowired
    @Setter
    private CaptainsState captainsState;
    @Getter
    private Dimension2D dimension;
    @Getter
    private String mapImagePath;
    @Getter
    @ListType(IFutureTowns.class)
    private final List<IFutureTowns> futureTowns = new ArrayList<>();
    @Getter
    @ListType(ILandBridge.class)
    private final List<ILandBridge> landbridges = new ArrayList<>();
    @Getter
    @ListType(PirateNest.class)
    private final List<PirateNest> pirateNests = new ArrayList<>();

    /**
     * Initialize the map by means of a list of its cities.
     * @param cities
     */
    public void setup(Date date, Collection<ICity> cities, Dimension2D dim, String mapName) {
        dimension = dim;
        mapImagePath = mapName;
        for (ICity city : cities) {
            this.cities.add(city);
        }
        captainsState.init(this);
    }
	@Override
	public int getNumberCities() {
		return cities.size();
	}

	@Override
	public List<ICity> getCities() {
		return Collections.unmodifiableList(cities);
	}

    @Override
    public ICity findCity(String cityName) {
        for (ICity city : cities) {
            if (city.getUniqueID().equals(cityName)) {
                return city;
            }
        }
        return null;
    }
}
