package ch.sahits.game.openpatrician.model.people;


import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;

public interface IContractBroker extends ITradePerson {
	/**
	 * Get the name of the contract broker.
	 * @return
	 */
	String getName();

    /**
     * Retrieve the amount and price that was agreed upon.
     * @return
     */
    AmountablePrice<IWare> getAmountAndPrice();

    /**
     * The ware that should be delivered.
     * @return
     */
    IWare getWare();

    /**
     * Retrieve the amount that was already delivered.
     * @return
     */
    int getDeliveredAmount();

    /**
     * Deliver a specified amount.
     * @param amount
     */
    void deliver(int amount);


}
