package ch.sahits.game.openpatrician.model.people;

import ch.sahits.game.openpatrician.model.product.IWare;
/**
 * Interface defining a person that trades ware.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 23, 2013
 *
 */
public interface ITradePerson extends IPerson{

	/**
	 * The ware the broker is to be delivered.
	 * @return
	 */
	IWare getWare();

	/**
	 * Amount of the ware that is to be delivered.
	 * The amount is in the ware specific quantity.
	 * @return
	 */
	int getAmount();

	/**
	 * Get the price of a single item
	 * @return
	 */
	int getAvgPricePerItem();
}