package ch.sahits.game.openpatrician.model.people;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.city.cityhall.IBowmen;
import ch.sahits.game.openpatrician.model.city.cityhall.ICrossbowmen;
import ch.sahits.game.openpatrician.model.city.cityhall.IMusketeer;
import ch.sahits.game.openpatrician.model.city.cityhall.IPikemen;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.Bowmen;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.Crossbowmen;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.Musketeer;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.Pikemen;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(StartNewGameBean.class)
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class PeopleFactory {
	@Autowired
	private ApplicationContext context;

	/**
	 * Retrieve a new captain.
	 * @return
	 */
	public ICaptain createNewCaptainProperty(){
		return context.getBean(ICaptain.class);
	}

    /**
     * Retrieve a contract broker
     * @return
     */
    public IContractBroker createNewContractBroker(AmountablePrice<IWare> amountable, IWare ware) {
        return (IContractBroker) context.getBean("contractBrookerState", new Object[]{amountable, ware});
    }
    public IBowmen createBowman() {
        return context.getBean(Bowmen.class);
    }
    public ICrossbowmen createCrossbowman() {
        return context.getBean(Crossbowmen.class);
    }
    public IPikemen createPikeman(){
        return context.getBean(Pikemen.class);
    }
    public IMusketeer createMusketeer() {
        return context.getBean(Musketeer.class);
    }

}
