package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.model.IUpdatableCityRelatedState;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.util.CityUtilities;
import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import lombok.Getter;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Random;
/**
 * Base implementation of a person that needs to travel from one location to another.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 26, 2013
 */
abstract class BaseTravelerState extends BaseTavernPerson implements IUpdatableCityRelatedState {
	@Getter
    private ICity destination;
    @Getter
	private int premium;
	@Autowired
	@XStreamOmitField
	private CityUtilities cityUtilities;
	@Autowired
	@XStreamOmitField
	private Random rnd;

	@Override
	public void update(ICity city) {
		premium = rnd.nextInt(1543)+324;
		this.destination = cityUtilities.findRandomCity(city);
		Preconditions.checkNotNull(this.destination);
	}

}