package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IUpdateableState;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.people.IBuyer;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import lombok.Getter;
import lombok.Setter;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Random;
/**
 * Implementation of a buyer. Every city can have a buyer and is referenced
 * through it's TavernEngine.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 20, 2013
 *
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class BuyerState extends BaseTavernPerson implements IBuyer, IUpdateableState {
	@Autowired
	@XStreamOmitField
	private Random rnd;
	@Autowired
	private Date date;
    @Getter
    @Setter
	private String name;
    @Setter
	private DateTime deadline;
    @Getter
    @Setter
	private IWare ware;
    @Setter
    @Getter
	private AmountablePrice<IWare> amountablePrice;
	/*
	 * Use custom names
	 */
	private static RandomNameLoader firstNameLoader = new RandomNameLoader("firstnames.properties");
	private static RandomNameLoader lastNameLoader = new RandomNameLoader("lastnames.properties");

	@Override
	public DateTime getTimeFrame() {
		return deadline;
	}

	@Override
	public void update() {
		setName(firstNameLoader.getRandomName()+" "+lastNameLoader.getRandomName());
		int days = rnd.nextInt(5);
		setDeadline(date.getCurrentDate().plusDays(5+days));
		int wareIndex = rnd.nextInt(EWare.values().length);
		IWare ware = EWare.values()[wareIndex];
		setWare(ware);
		int amount = rnd.nextInt(21)+3; // TODO aho Jan 27, 2013: differentiate between bale and barrel
		int price = ware.computeBuyPrice(5, amount);
		AmountablePrice<IWare> amt = new AmountablePrice<IWare>();
		amt.add(amount, price);
		setAmountablePrice(amt);

	}
}
