package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.AIPlayerList;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.IUpdateableState;
import ch.sahits.game.openpatrician.model.people.IConcurrent;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Random;

/**
 * Implementation of a concurrent. Every city can have a concurrent and is referenced
 * through it's TavernEngine.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 20, 2013
 *
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class ConcurrentState extends BaseTavernPerson implements IConcurrent, IUpdateableState {

	@Autowired
	@XStreamOmitField
	private Random rnd;
	@Autowired
	private AIPlayerList aiPlayers;
    @Getter
    @Setter
	private IPlayer clientPlayer;
    @Getter
    @Setter
	private IPlayer concurrentPlayer;
    @Getter
    @Setter
	private int premium;

	@Override
	public String getName() {
		return clientPlayer.getName()+" "+clientPlayer.getLastName();
	}
	@Override
	public String getConcurrentName() {
		return concurrentPlayer.getName()+" "+concurrentPlayer.getLastName();
	}


	/**
	 * Update the concurrent with a new pair and premium.
	 */
	@Override
	public void update() {
		List<IAIPlayer> players = aiPlayers.getAll();
        final int index = rnd.nextInt(players.size());

        IPlayer p1 = players.get(index);
        int other = rnd.nextInt(players.size());
        while (other == index) {
            other = rnd.nextInt(players.size());
        }
		IPlayer p2 = players.get(other);
		setClientPlayer(p1);
		setConcurrentPlayer(p2);
		setPremium(rnd.nextInt(8500)+1500);
	}

}
