package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.IUpdatableCityRelatedState;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.ITrader;
import ch.sahits.game.openpatrician.model.util.CityUtilities;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.util.Random;

/**
 * Implementation of a trader. Every city can have a trader and is referenced
 * through it's TavernEngine.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 20, 2013
 *
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class TraderState extends BaseTavernPerson implements ITrader, IUpdatableCityRelatedState {
	@Autowired
    @Qualifier("baseTradePerson")
	private BaseTradePerson tradePerson;
	@Autowired
	@XStreamOmitField
	private Random rnd;

	@Autowired
	@XStreamOmitField
	private CityUtilities cityUtils;

	@Override
	public IWare getWare() {
		return tradePerson.getWare();
	}

	/**
	 * Define the ware the broker expects to be delivered.
	 * @param ware
	 */
	public void setWare(IWare ware) {
		tradePerson.setWare(ware);
	}

	@Override
	public int getAmount() {
		return tradePerson.getAmount();
	}

	@Override
	public int getAvgPricePerItem() {
		return tradePerson.getAvgPricePerItem();
	}

	/**
	 * Define the amount of the ware to be delivered in the ware
	 * specific size.
	 * @param amount
	 */
	public void setAmount(int amount) {
		tradePerson.setAmount(amount);
	}

	/**
	 * Define the average price per item.
	 */
	public void setAvgPricePerItem(int avgPricePerItem) {
		tradePerson.setAvgPricePerItem(avgPricePerItem);
	}



	@Override
	public void update(ICity city) {
		EWare ware = EWare.values()[rnd.nextInt(EWare.values().length)];
        final AmountablePrice<IWare> amountablePrice = city.getWare(ware);
        int availableAmount = amountablePrice.getAmount();
		while (availableAmount == 0){
			ware = EWare.values()[rnd.nextInt(EWare.values().length)];
			availableAmount = city.getWare(ware).getAmount();
		}
		int amount;
		if (ware.getSizeAsBarrels() == 1) {
			amount = rnd.nextInt(100);
		} else {
			amount = rnd.nextInt(20);
		}
		amount = Math.max(1, amount);
		tradePerson.setAmount(amount);
		double variance = rnd.nextDouble()*0.25-0.125;
		int newPrice = (int) Math.abs(Math.rint(variance*ware.computeSellPrice(availableAmount, amount)));
		tradePerson.setAvgPricePerItem(newPrice);
		tradePerson.setWare(ware);

	}




}
