package ch.sahits.game.openpatrician.model.product;

import ch.sahits.game.openpatrician.util.PropertyLoader;
import com.google.common.base.Preconditions;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.IntegerProperty;

import java.util.Properties;
/**
 * Define the different type of wares that are produced and can be traded.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Nov 20, 2011
 *
 */
public enum EWare implements IWare {
	/*
	 * The order of the enumation is important
	 * as it is the order as it is in the dialogs.
	 */
	/** Beer in barrels */
	BEER("beer.properties"),
	/** Iron ore in burden */
	IRONORE("ironore.properties"),
	/** Iron in barrels */
	IRON("iron.properties"),
	/** Fur in barrels */
	FUR("fur.properties"),
	/** Fish in burden */
	FISH("fish.properties"),
	/** Meat in burden */
	MEAT("meat.properties"),
	/** Grain in burden */
	GRAIN("grain.properties"),
	/** Spices in barrels */
	SPICE("spice.properties"),
	/** Hemp in burden */
	HEMP("hemp.properties"),
	/** Wood in burden */
	WOOD("wood.properties"),
	/** Honey in barrels */
	HONEY("honey.properties"),
	/** Pottery in barrels */
	POTTERY("pottery.properties"),
	/** Leather in barrels */
	LEATHER("leather.properties"),
	/** Pitch in barrels */
	PITCH("pitch.properties"),
	/** Salt in barrels */
	SALT("salt.properties"),
	/** Fish oil in barrels */
	FISH_OIL("fishoil.properties"),
	/** Cloth in barrels */
	CLOTH("cloth.properties"),
	/** Wine in barrels */
	WINE("wine.properties"),
	/** Wool in burden */
	WOOL("wool.properties"),
	/** Brick in burden */
	BRICK("brick.properties");
	/*
	 * For now the algorithm for the price is implemented here
	 * this means the price development is always the same.
	 */

	private final EWareSize size;
	private final int maxValueBuy;
	private final int minValueBuy;
	private final int maxValueSell;
	private final int minValueSell;
	private final int saturation;
	private final String wareID;

	private final ComputablePrice computablePrice;
	/**
	 * Initialize the ware based on a configuration file
	 * @param configFileName file name of the configuration property file
	 */
	EWare(String configFileName){
		Properties props = PropertyLoader.loadProperties(configFileName);
		Preconditions.checkNotNull(props.getProperty("type"), "The property file "+configFileName+" does not contain the type property");
		Preconditions.checkNotNull(props.getProperty("sizeUnit"), "The property file "+configFileName+" does not contain the sizeUnit property");
		Preconditions.checkNotNull(props.getProperty("maxValueBuy"), "The property file "+configFileName+" does not contain the maxValueBuy property");
		Preconditions.checkNotNull(props.getProperty("minValueBuy"), "The property file "+configFileName+" does not contain the minValueBuy property");
		Preconditions.checkNotNull(props.getProperty("maxValueSell"), "The property file "+configFileName+" does not contain the maxValueSell property");
		Preconditions.checkNotNull(props.getProperty("minValueSell"), "The property file "+configFileName+" does not contain the maxValueSell property");
		Preconditions.checkNotNull(props.getProperty("localisationID"), "The property file "+configFileName+" does not contain the localisationID property");
		Preconditions.checkNotNull(props.getProperty("saturation"), "The property file "+configFileName+" does not contain the saturation property");
		size=EWareSize.valueOf(props.getProperty("sizeUnit"));
		maxValueBuy=Integer.parseInt(props.getProperty("maxValueBuy"));
		minValueBuy=Integer.parseInt(props.getProperty("minValueBuy"));
		wareID=props.getProperty("localisationID");
		saturation=Integer.parseInt(props.getProperty("saturation"));
		minValueSell=Integer.parseInt(props.getProperty("minValueSell"));
		maxValueSell=Integer.parseInt(props.getProperty("maxValueSell"));
		computablePrice = new ComputablePrice(maxValueBuy, minValueBuy, maxValueSell, minValueSell, saturation, name());
	}

	@Override
	public final boolean isBarrelSizedWare() {
		return size == EWareSize.BARREL;
	}
	/* (non-Javadoc)
	 * @see ch.sahits.game.openpatrician.model.product.IWare#getSizeAsBarrels()
	 */
	@Override
	public final short getSizeAsBarrels(){
		return size.getRealMasurement();
	}
	@Override
	@Deprecated
	public int computeSellPrice(int availableAmount, int amountToSell) {
		return computablePrice.computeSellPrice(availableAmount, amountToSell);
	}
	@Override
	@Deprecated
	public int computeBuyPrice(int availableAmount, int amountToBuy) {
		return computablePrice.computeBuyPrice(availableAmount, amountToBuy);
	}
	@Override
	public int sellPrice(IntegerProperty availableAmount, IntegerBinding amountToSell) {
		return computablePrice.sellPrice(availableAmount, amountToSell);
	}
	@Override
	public int buyPrice(IntegerProperty availableAmount, IntegerBinding amountToBuy) {
		return computablePrice.buyPrice(availableAmount, amountToBuy);
	}
	
	public int computePrice(IntegerProperty available,
			IntegerBinding amountToBuy) {
		return computablePrice.buyPrice(available, amountToBuy);
	}

	@Override
	public int getMaxValueBuy() {
		return computablePrice.getMaxValueBuy();
	}
	@Override
	public int getMaxValueSell() {
		return computablePrice.getMaxValueSell();
	}
	@Override
	public int getMinValueSell() {
		return computablePrice.getMinValueSell();
	}
	@Override
	public int getMinValueBuy() {
		return computablePrice.getMinValueBuy();
	}
	@Override
	public int getMarketSaturation() {
		return computablePrice.getMarketSaturation();
	}

	public String getWareID() {
		return wareID;
	}

}
