package ch.sahits.game.openpatrician.model.ship.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.ship.ISnaikka;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;

import java.util.Properties;

@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class Snaikka extends Ship implements ISnaikka {
	/**
	 * Constructor initializing the name and the upgrade level
	 * @param upgradeLevel
	 * @param name ships name
	 * @param shipConfiguration configuration properties
	 */
	public Snaikka(EShipUpgrade upgradeLevel, String name, Properties shipConfiguration) {
		super(shipConfiguration);
		this.shipUpgradeLevel = upgradeLevel;
		this.name = name;
		ShipWeaponsLocationFactory factory = new ShipWeaponsLocationFactory();
		setShipWeaponsLocation(factory.getShipWeaponsLocation(EShipType.SNAIKKA, upgradeLevel));
	}
	/**
	 * Constructor for a Crayer without any upgrade
	 * @param name ships name
	 * @param shipConfiguration configuration properties
	 */
	public Snaikka(String name, Properties shipConfiguration) {
		this(EShipUpgrade.NONE,name, shipConfiguration);
	}
	@Override
	public int getDamage() {
		// TODO Auto-generated method stub
		return 0;
	}
	@Override
	public void damage(Object damage) {
		// TODO Auto-generated method stub

	}
	@Override
	public void repair() {
		// TODO Auto-generated method stub

	}

	@Override
	public EShipType getShipType() {
		return EShipType.SNAIKKA;
	}

}
