package ch.sahits.game.openpatrician.model.ship.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.ship.EShipSide;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * This class defines a weapon and its location on board a ship.
 * There are weapons that take up two slots.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 23, 2011
 *
 */
@RequiredArgsConstructor
@Getter
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
final class WeaponsLocation {
	/** Side of the ship either port or starboard */
    @Getter
	private final EShipSide side;
	/** The weapon in the slot */
    @Getter
	private final EWeapon weapon;

}
