package ch.sahits.game.openpatrician.model.weapon;

import ch.sahits.game.openpatrician.model.product.ComputablePrice;
import ch.sahits.game.openpatrician.util.PropertyLoader;
import com.google.common.base.Preconditions;

import java.util.Properties;

/**
 * Enumeration defining all weapons
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 23, 2011
 *
 */
public enum EWeapon implements IWeapon {
	SWORD("sword.properties"),
	BOW("bow.properties"),
	CROSSBOW("crossbow.properties"),
	MUSKET("musket.properties"),
	BALLISTA_SMALL("ballista_small.properties"),
	TREBUCHET_SMALL("trebuchet_small.properties"),
	BALLISTA_BIG("ballista_big.properties"),
	TREBUCHET_BIG("trebuchet_big.properties"),
	BOMBARD("bombard.properties"),
	CANNON("cannon.properties"),
	HAND_WEAPON("hand_weapon.properties");
//	private final Locale locale = Locale.getInstance();
	
	private final int maxValueBuy;
	private final int minValueBuy;
	private final int maxValueSell;
	private final int minValueSell;
	private final int saturation;

	
	private ComputablePrice computablePrice;

    private EWeapon(String configFileName) {
		Properties props = PropertyLoader.loadProperties(configFileName);
		Preconditions.checkNotNull(props.getProperty("maxValueBuy"), "The property file "+configFileName+" does not contain the maxValueBuy property");
		Preconditions.checkNotNull(props.getProperty("minValueBuy"), "The property file "+configFileName+" does not contain the minValueBuy property");
		Preconditions.checkNotNull(props.getProperty("maxValueSell"), "The property file "+configFileName+" does not contain the maxValueSell property");
		Preconditions.checkNotNull(props.getProperty("minValueSell"), "The property file "+configFileName+" does not contain the minValueSell property");
		Preconditions.checkNotNull(props.getProperty("saturation"), "The property file "+configFileName+" does not contain the saturation property");
		maxValueBuy=Integer.parseInt(props.getProperty("maxValueBuy"));
		minValueBuy=Integer.parseInt(props.getProperty("minValueBuy"));
		saturation=Integer.parseInt(props.getProperty("saturation"));
		minValueSell=Integer.parseInt(props.getProperty("minValueSell"));
		maxValueSell=Integer.parseInt(props.getProperty("maxValueSell"));
		computablePrice = new ComputablePrice(maxValueBuy, minValueBuy, maxValueSell, minValueSell, saturation, name());		
	}

	@Override
    @Deprecated
	public int computeSellPrice(int availableAmount, int amountToSell) {
        final int sellPrice = computablePrice.computeSellPrice(availableAmount, amountToSell);
        return sellPrice;
	}
	@Override
    @Deprecated
	public int computeBuyPrice(int availableAmount, int amountToBuy) {
		return computablePrice.computeBuyPrice(availableAmount, amountToBuy);
	}

}
