package ch.sahits.game.openpatrician.util;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.data.map.Map;
import ch.sahits.game.openpatrician.data.map.MapSegments;
import ch.sahits.game.openpatrician.data.map.PirateNest;
import ch.sahits.game.openpatrician.data.map.SunkenTreasure;
import ch.sahits.game.openpatrician.model.MapSegmentedImage;
import ch.sahits.game.openpatrician.model.city.CityFactory;
import javafx.geometry.Point2D;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/**
 * This factory can only be used after it is initialized which is dependent on
 * the deserialisation of the map.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Nov 13, 2014
 */
@LazySingleton
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class MapSegmentImageFactory {
    @Autowired
    private Random rnd;
    @Autowired
    private CityFactory cityFactory;

    @ListType(MapSegmentedImage.class)
    private List<MapSegmentedImage> pirateHideOuts;
    @ListType(MapSegmentedImage.class)
    private List<MapSegmentedImage> sunkShips;

    public void initializeImages() {
        Map map = cityFactory.getMap();
        pirateHideOuts = new ArrayList<>();
        sunkShips = new ArrayList<>();
        final MapSegments mapSegments = map.getMapSegments();
        for (PirateNest pirateNest : mapSegments.getPirateNest()) {
            pirateHideOuts.add(new MapSegmentedImage(pirateNest.getSegment(), new Point2D(pirateNest.getX(), pirateNest.getX())));
        }
        for (SunkenTreasure sunkenTreasure : mapSegments.getSunkenTreasure()) {
            sunkShips.add(new MapSegmentedImage(sunkenTreasure.getSegment(), new Point2D(sunkenTreasure.getX(), sunkenTreasure.getX())));
        }

    }

    public MapSegmentedImage getRandomPirateNest() {
        return getRandomImage(pirateHideOuts);
    }
    public MapSegmentedImage getRandomTreasureNest() {
        return getRandomImage(sunkShips);
    }
    private MapSegmentedImage getRandomImage(List<MapSegmentedImage> imgList) {
        MapSegmentedImage img = imgList.get(rnd.nextInt(imgList.size()));
        int availableSegment = rnd.nextInt(9);
        img.addSegment(availableSegment);
        return img;
    }
}
