/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.IAmountable;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;

@ClassCategory(value={EClassCategory.MODEL, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class BaseAmountable<T extends IAmountable> {
    protected final IntegerProperty amount = new SimpleIntegerProperty((Object)this, "amount", 0);

    public int getAmount() {
        return this.amount.get();
    }

    public void add(int amount) {
        if (amount < 0) {
            amount = Math.abs(amount);
        }
        this.amount.set(this.getAmount() + amount);
    }

    public void remove(int amount) {
        if (amount < 0) {
            amount = Math.abs(amount);
        }
        if (amount == Integer.MIN_VALUE) {
            amount = Integer.MAX_VALUE;
        }
        if (this.amount.get() < amount) {
            this.amount.set(0);
        } else {
            this.amount.set(this.getAmount() - amount);
        }
    }

    public void reset() {
        this.amount.set(0);
    }

    public String toString() {
        return String.valueOf(this.amount.get());
    }

    public IntegerProperty amountProperty() {
        return this.amount;
    }
}

