/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.collections.NonReplacableMap;
import ch.sahits.game.openpatrician.data.map.Landbridge;
import ch.sahits.game.openpatrician.data.map.Map;
import ch.sahits.game.openpatrician.data.map.Newtown;
import ch.sahits.game.openpatrician.model.AIPlayerList;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.Difficulty;
import ch.sahits.game.openpatrician.model.EGameSpeed;
import ch.sahits.game.openpatrician.model.EObjective;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IGame;
import ch.sahits.game.openpatrician.model.ILandBridge;
import ch.sahits.game.openpatrician.model.IMap;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.PlayerList;
import ch.sahits.game.openpatrician.model.city.CityFactory;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.IFutureTowns;
import ch.sahits.game.openpatrician.model.city.impl.CityRegistry;
import ch.sahits.game.openpatrician.model.city.impl.CityState;
import ch.sahits.game.openpatrician.model.factory.BuildingFactory;
import ch.sahits.game.openpatrician.model.impl.FutureTowns;
import ch.sahits.game.openpatrician.model.impl.GameMap;
import ch.sahits.game.openpatrician.model.impl.LandBridge;
import ch.sahits.game.openpatrician.model.people.ReputationCalculator;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.personal.impl.PersonalData;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class GameFactory {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    private Random rnd;
    @Autowired
    private CityFactory cityFactory;
    @Autowired
    private Date date;
    @Autowired
    private BuildingFactory buildingFactory;
    private NonReplacableMap<String, Object> beanMap = new NonReplacableMap();
    @Autowired
    private ApplicationContext context;
    @Autowired
    private CityRegistry cityRegistry;
    @Autowired
    private PlayerList players;
    @Autowired
    private AIPlayerList aiPlayers;

    public IPlayer createPlayer(String name, String lastName, ICity homeTown, boolean male, int cash) {
        int age = this.rnd.nextInt(10) + 17;
        PersonalData pd = new PersonalData(name, lastName, male, homeTown, this.computeRandomBirthDate(age));
        IPlayer player = (IPlayer)this.context.getBean("player", new Object[]{homeTown, pd, cash, ESocialRank.CHANDLER, this});
        this.buildingFactory.createTradingOffice(player, homeTown, 0);
        this.initPlayerInCities(player);
        this.players.add(player);
        return player;
    }

    public IAIPlayer createAIPlayer(ICity homeTown, long cash) {
        int age = this.rnd.nextInt(15) + 17;
        IAIPlayer player = (IAIPlayer)this.context.getBean("aiPlayer", new Object[]{homeTown, cash, this.computeRandomBirthDate(age), this});
        this.buildingFactory.createTradingOffice(player, homeTown, 0);
        this.initPlayerInCities(player);
        this.players.add(player);
        this.aiPlayers.add(player);
        return player;
    }

    private void initPlayerInCities(IPlayer player) {
        for (ICity city : this.cityFactory.getCities()) {
            city.moveIn(player);
        }
    }

    public IMap createMap(String mapName) throws IOException {
        this.cityFactory.initializeCityCache(mapName);
        Map m = this.cityFactory.getMap();
        GameMap map = (GameMap)this.context.getBean(IMap.class);
        Dimension2D dim = new Dimension2D((double)m.getDimension().getX().shortValue(), (double)m.getDimension().getY().shortValue());
        map.setup(this.date, this.cityFactory.getCities(), dim, m.getImageName());
        List<Newtown> newTowns = m.getNewlocations().getNewtown();
        List<IFutureTowns> futures = map.getFutureTowns();
        for (Newtown newTown : newTowns) {
            futures.add(new FutureTowns(newTown.getName(), new Point2D((double)newTown.getNewlocation().getX().byteValue(), (double)newTown.getNewlocation().getY().shortValue())));
        }
        List<Landbridge> bridges = m.getLandbridges().getLandbridge();
        List<ILandBridge> landbridges = map.getLandbridges();
        for (Landbridge bridge : bridges) {
            ICity from = map.findCity(bridge.getFrom());
            ICity to = map.findCity(bridge.getTo());
            if (from == null) {
                this.logger.warn("The from location for the land bridge could not be found: " + bridge.getFrom());
                continue;
            }
            if (to == null) {
                this.logger.warn("The to location for the land bridge could not be found: " + bridge.getTo());
                continue;
            }
            landbridges.add(new LandBridge(from, to));
        }
        this.context.getBean(StartNewGameBean.class);
        return map;
    }

    public IGame createGame(IMap map, EObjective objective, Difficulty difficulty, EGameSpeed speed, int startYear, boolean singleplayer) {
        if (!this.beanMap.containsKey((Object)"game")) {
            this.beanMap.put((Object)"game", this.context.getBean("game", new Object[]{objective, difficulty, speed, singleplayer}));
        }
        return (IGame)this.beanMap.get((Object)"game");
    }

    public IGame getGame() {
        return (IGame)this.beanMap.get((Object)"game");
    }

    private DateTime computeRandomBirthDate(int age) {
        int year = this.date.getStartYear() - age;
        int month = this.rnd.nextInt(12) + 1;
        int day = month == 2 ? this.rnd.nextInt(28) + 1 : (month == 4 || month == 6 || month == 9 || month == 11 ? this.rnd.nextInt(30) + 1 : this.rnd.nextInt(31) + 1);
        return new DateTime(year, month, day, 0, 0);
    }

    public CityState getCityState(ICity city) {
        List<CityState> cityStates = this.cityRegistry.getCityStates();
        if (cityStates.contains(city)) {
            return cityStates.get(cityStates.indexOf(city));
        }
        CityState state = this.initCityPropertyState(city);
        return state;
    }

    private CityState initCityPropertyState(ICity city) {
        CityState state = (CityState)this.context.getBean("cityState", new Object[]{city});
        this.cityRegistry.add(state);
        return state;
    }

    public ReputationCalculator getReputationCalculator() {
        return (ReputationCalculator)this.context.getBean(ReputationCalculator.class);
    }

    public ICompany createCompany(IPlayer owner, ICity homeTown, long cash) {
        return (ICompany)this.context.getBean("company", new Object[]{owner, homeTown, cash});
    }
}

