/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.building.impl;

import ch.sahits.game.event.data.PeriodicalTimeWeekUpdate;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IBalanceSheet;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.IAutomatedTrading;
import ch.sahits.game.openpatrician.model.building.ISteward;
import ch.sahits.game.openpatrician.model.building.IStorage;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.building.IWeaponStorage;
import ch.sahits.game.openpatrician.model.building.impl.WeaponStorage;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.factory.BuildingFactory;
import ch.sahits.game.openpatrician.model.factory.PlayerInteractionFactory;
import ch.sahits.game.openpatrician.model.impl.BalanceSheet;
import ch.sahits.game.openpatrician.model.impl.WareHolding;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class TradingOffice
extends WareHolding
implements ITradingOffice {
    @Autowired
    @XStreamOmitField
    private BuildingFactory buildingFactory;
    @Autowired
    @XStreamOmitField
    private PlayerInteractionFactory interactionFactory;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;
    private static final int MAX_CAPACITY = 500;
    private final IPlayer owner;
    private final ICity city;
    private final int baseValue;
    private final IWeaponStorage weaponStorage;
    private int propertyTax = 5;
    private IStorage storage;
    @ObjectPropertyType(value=ISteward.class)
    private ObjectProperty<ISteward> steward;
    private IBalanceSheet balanceLastWeek;
    private IBalanceSheet currentWeek;
    @Autowired
    private IAutomatedTrading officeTrading;
    private IntegerProperty capacity = new SimpleIntegerProperty((Object)this, "capacity", 500);
    @XStreamOmitField
    private BooleanBinding storageManagerPresent = null;

    public TradingOffice(IPlayer player, ICity city, int value) {
        this.owner = player;
        this.city = city;
        this.baseValue = value;
        this.steward = new SimpleObjectProperty((Object)this, "steward", null);
        this.weaponStorage = new WeaponStorage();
    }

    @PostConstruct
    private void init() {
        if (this.storage == null) {
            this.storage = this.buildingFactory.createStorage(this.owner, this.city);
        }
        if (!this.containsWare(EWare.GRAIN)) {
            this.initWares();
        } else {
            this.bindWares();
        }
        if (this.balanceLastWeek == null) {
            this.balanceLastWeek = this.interactionFactory.createInitialBalanceSheet(this.city, this.owner);
        }
        if (this.currentWeek == null) {
            this.currentWeek = this.interactionFactory.createBalanceSheetFromPreviousWeek((BalanceSheet)this.balanceLastWeek);
        }
        this.clientServerEventBus.register((Object)this);
    }

    @Override
    @PreDestroy
    public void destroy() {
        this.unbindAllAmounts();
        this.clientServerEventBus.unregister((Object)this);
    }

    private void initWares() {
        for (EWare ware : EWare.values()) {
            this.addNewWare(ware, 0);
        }
    }

    private void bindWares() {
        for (EWare ware : EWare.values()) {
            this.bindStoredAmount(this.getWare(ware).amountProperty());
        }
    }

    @Override
    public IntegerProperty capacityProperty() {
        return this.capacity;
    }

    @Override
    public boolean hasWeapons() {
        return this.weaponStorage.hasWeapons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int move(IWeapon weapon, int amount) {
        IWeapon iWeapon = weapon;
        synchronized (iWeapon) {
            return this.weaponStorage.update(weapon, amount);
        }
    }

    @Override
    protected int computeAVGPrice(IWare ware, int amount) {
        int available = this.city.getWare(ware).getAmount();
        return ware.computeSellPrice(available, amount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int move(IWare ware, int amount, int avgPrice) {
        IWare iWare = ware;
        synchronized (iWare) {
            AmountablePrice<IWare> amounted = this.getWare(ware);
            if (amount < 0 && this.containsWare(ware) && amounted != null && -amount > amounted.getAmount()) {
                amount = -amounted.getAmount();
            }
            if (amount < 0 && !this.containsWare(ware)) {
                amount = 0;
            }
            if (!this.containsWare(ware)) {
                new IllegalStateException("All wares should be initialized, allowed in test").printStackTrace();
            }
            if (amount > 0) {
                amounted.add(amount, avgPrice);
            } else {
                amounted.remove(amount);
            }
            return amount;
        }
    }

    @Override
    public ISteward getSteward() {
        return (ISteward)this.steward.get();
    }

    @Override
    public void setSteward(ISteward steward) {
        this.steward.set((Object)steward);
    }

    @Override
    public ObjectProperty<ISteward> stewardProperty() {
        return this.steward;
    }

    @Subscribe
    public void handleWeeklyUpdates(PeriodicalTimeWeekUpdate event) {
        BalanceSheet newWeek = this.interactionFactory.createBalanceSheetFromPreviousWeek((BalanceSheet)this.currentWeek);
        this.balanceLastWeek = this.currentWeek;
        this.currentWeek = newWeek;
    }

    @Override
    public int move(IWare ware, int amount) {
        return super.move(ware, amount, this.owner);
    }

    @Override
    public int getValue() {
        return this.baseValue;
    }

    @Override
    public BooleanBinding storageManagerPresentBinding() {
        if (this.storageManagerPresent == null) {
            this.storageManagerPresent = new BooleanBinding(){

                protected boolean computeValue() {
                    return TradingOffice.this.steward.get() != null;
                }
            };
        }
        return this.storageManagerPresent;
    }

    @Override
    public IPlayer getOwner() {
        return this.owner;
    }

    @Override
    public ICity getCity() {
        return this.city;
    }

    @Override
    public IWeaponStorage getWeaponStorage() {
        return this.weaponStorage;
    }

    @Override
    public int getPropertyTax() {
        return this.propertyTax;
    }

    @Override
    public IStorage getStorage() {
        return this.storage;
    }

    @Override
    public IBalanceSheet getBalanceLastWeek() {
        return this.balanceLastWeek;
    }

    @Override
    public IBalanceSheet getCurrentWeek() {
        return this.currentWeek;
    }

    @Override
    public IAutomatedTrading getOfficeTrading() {
        return this.officeTrading;
    }
}

