/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.cityhall.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.annotation.OptionalType;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.cityhall.IAcceptedEldermanTask;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.IEldermanOffice;
import ch.sahits.game.openpatrician.model.city.cityhall.IEldermanTask;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.AcceptedEldermanTask;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javafx.collections.ObservableList;
import org.joda.time.DateTime;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class EldermanOffice
implements IEldermanOffice {
    @ListType(value=IEldermanTask.class)
    private final ObservableList<IEldermanTask> tasks;
    @OptionalType(value=ICityViolation.class)
    private Optional<ICityViolation> violation = Optional.empty();
    @ListType(value=IAcceptedEldermanTask.class)
    private List<IAcceptedEldermanTask> workedOnTasks = new ArrayList<IAcceptedEldermanTask>();

    public EldermanOffice(ObservableList<IEldermanTask> tasks) {
        this.tasks = tasks;
    }

    @Override
    public void update() {
    }

    @Override
    public void addTask(IEldermanTask task, DateTime limit, IPlayer player) {
        this.workedOnTasks.add(new AcceptedEldermanTask(task, limit, player));
    }

    @Override
    public void finished(IEldermanTask task) {
        Iterator<IAcceptedEldermanTask> iterator = this.workedOnTasks.iterator();
        while (iterator.hasNext()) {
            IAcceptedEldermanTask next = iterator.next();
            if (!task.equals(next.getTask())) continue;
            iterator.remove();
            break;
        }
    }

    public ObservableList<IEldermanTask> getTasks() {
        return this.tasks;
    }

    @Override
    public Optional<ICityViolation> getViolation() {
        return this.violation;
    }

    public void setViolation(Optional<ICityViolation> violation) {
        this.violation = violation;
    }

    @Override
    public List<IAcceptedEldermanTask> getWorkedOnTasks() {
        return this.workedOnTasks;
    }
}

