/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.cityhall.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.city.cityhall.ITreasury;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleLongProperty;

@ClassCategory(value={EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class Treasury
implements ITreasury {
    private double currentHeadTaxValue = 4.0;
    private double currentPropertyTax = 280.0;
    private long paidTaxes = 0L;
    private long paidSpecialTaxes = 0L;
    private int cityGuardCosts = 0;
    private int buildingCosts = 0;
    private int outriggerCosts = 0;
    private int siegeCosts = 0;
    private int otherCosts = 0;
    private int otherIncome = 0;
    private int donations = 0;
    private LongProperty cash = new SimpleLongProperty(0L);

    public void reset() {
        this.paidTaxes = 0L;
        this.paidSpecialTaxes = 0L;
        this.cityGuardCosts = 0;
        this.buildingCosts = 0;
        this.outriggerCosts = 0;
        this.siegeCosts = 0;
        this.otherIncome = 0;
        this.otherCosts = 0;
        this.donations = 0;
    }

    public void setCurrentHeadTaxValue(double currentHeadTaxValue) {
        this.currentHeadTaxValue = currentHeadTaxValue;
    }

    public void setCurrentPropertyTax(double currentPropertyTax) {
        this.currentPropertyTax = currentPropertyTax;
    }

    public void addPaidTaxes(long paidTaxes) {
        this.paidTaxes += paidTaxes;
        this.cash.setValue((Number)(this.cash.get() + paidTaxes));
    }

    public void addPaidSpecialTaxes(long paidSpecialTaxes) {
        this.paidSpecialTaxes += paidSpecialTaxes;
        this.cash.setValue((Number)(this.cash.get() + paidSpecialTaxes));
    }

    public void subtractCityGuardCosts(int cityGuardCosts) {
        this.cityGuardCosts -= cityGuardCosts;
        this.cash.setValue((Number)(this.cash.get() - (long)cityGuardCosts));
    }

    public void subtractBuildingCosts(int buildingCosts) {
        this.buildingCosts -= buildingCosts;
        this.cash.setValue((Number)(this.cash.get() - (long)buildingCosts));
    }

    public void subtractOutriggerCosts(int outriggerCosts) {
        this.outriggerCosts -= outriggerCosts;
        this.cash.setValue((Number)(this.cash.get() - (long)outriggerCosts));
    }

    public void subtractSiegeCosts(int siegeCosts) {
        this.siegeCosts -= siegeCosts;
        this.cash.setValue((Number)(this.cash.get() - (long)siegeCosts));
    }

    public void subtractOtherCosts(int otherCosts) {
        this.otherCosts -= otherCosts;
        this.cash.setValue((Number)(this.cash.get() - (long)otherCosts));
    }

    public void addOtherIncome(int otherIncome) {
        this.otherIncome += otherIncome;
        this.cash.setValue((Number)(this.cash.get() + (long)otherIncome));
    }

    public void addDonations(int donations) {
        this.donations += donations;
        this.cash.setValue((Number)(this.cash.get() + (long)donations));
    }

    @Override
    public long getCash() {
        return this.cash.get();
    }

    public LongProperty cashProperty() {
        return this.cash;
    }

    public void setCash(long cash) {
        this.cash.set(cash);
    }

    Treasury(double currentHeadTaxValue, double currentPropertyTax, long paidTaxes, long paidSpecialTaxes, int cityGuardCosts, int buildingCosts, int outriggerCosts, int siegeCosts, int otherCosts, int otherIncome, int donations, LongProperty cash) {
        this.currentHeadTaxValue = currentHeadTaxValue;
        this.currentPropertyTax = currentPropertyTax;
        this.paidTaxes = paidTaxes;
        this.paidSpecialTaxes = paidSpecialTaxes;
        this.cityGuardCosts = cityGuardCosts;
        this.buildingCosts = buildingCosts;
        this.outriggerCosts = outriggerCosts;
        this.siegeCosts = siegeCosts;
        this.otherCosts = otherCosts;
        this.otherIncome = otherIncome;
        this.donations = donations;
        this.cash = cash;
    }

    public static TreasuryBuilder builder() {
        return new TreasuryBuilder();
    }

    @Override
    public double getCurrentHeadTaxValue() {
        return this.currentHeadTaxValue;
    }

    @Override
    public double getCurrentPropertyTax() {
        return this.currentPropertyTax;
    }

    @Override
    public long getPaidTaxes() {
        return this.paidTaxes;
    }

    @Override
    public long getPaidSpecialTaxes() {
        return this.paidSpecialTaxes;
    }

    @Override
    public int getCityGuardCosts() {
        return this.cityGuardCosts;
    }

    @Override
    public int getBuildingCosts() {
        return this.buildingCosts;
    }

    @Override
    public int getOutriggerCosts() {
        return this.outriggerCosts;
    }

    @Override
    public int getSiegeCosts() {
        return this.siegeCosts;
    }

    @Override
    public int getOtherCosts() {
        return this.otherCosts;
    }

    @Override
    public int getOtherIncome() {
        return this.otherIncome;
    }

    @Override
    public int getDonations() {
        return this.donations;
    }

    public static class TreasuryBuilder {
        private double currentHeadTaxValue;
        private double currentPropertyTax;
        private long paidTaxes;
        private long paidSpecialTaxes;
        private int cityGuardCosts;
        private int buildingCosts;
        private int outriggerCosts;
        private int siegeCosts;
        private int otherCosts;
        private int otherIncome;
        private int donations;
        private LongProperty cash;

        TreasuryBuilder() {
        }

        public TreasuryBuilder currentHeadTaxValue(double currentHeadTaxValue) {
            this.currentHeadTaxValue = currentHeadTaxValue;
            return this;
        }

        public TreasuryBuilder currentPropertyTax(double currentPropertyTax) {
            this.currentPropertyTax = currentPropertyTax;
            return this;
        }

        public TreasuryBuilder paidTaxes(long paidTaxes) {
            this.paidTaxes = paidTaxes;
            return this;
        }

        public TreasuryBuilder paidSpecialTaxes(long paidSpecialTaxes) {
            this.paidSpecialTaxes = paidSpecialTaxes;
            return this;
        }

        public TreasuryBuilder cityGuardCosts(int cityGuardCosts) {
            this.cityGuardCosts = cityGuardCosts;
            return this;
        }

        public TreasuryBuilder buildingCosts(int buildingCosts) {
            this.buildingCosts = buildingCosts;
            return this;
        }

        public TreasuryBuilder outriggerCosts(int outriggerCosts) {
            this.outriggerCosts = outriggerCosts;
            return this;
        }

        public TreasuryBuilder siegeCosts(int siegeCosts) {
            this.siegeCosts = siegeCosts;
            return this;
        }

        public TreasuryBuilder otherCosts(int otherCosts) {
            this.otherCosts = otherCosts;
            return this;
        }

        public TreasuryBuilder otherIncome(int otherIncome) {
            this.otherIncome = otherIncome;
            return this;
        }

        public TreasuryBuilder donations(int donations) {
            this.donations = donations;
            return this;
        }

        public TreasuryBuilder cash(LongProperty cash) {
            this.cash = cash;
            return this;
        }

        public Treasury build() {
            return new Treasury(this.currentHeadTaxValue, this.currentPropertyTax, this.paidTaxes, this.paidSpecialTaxes, this.cityGuardCosts, this.buildingCosts, this.outriggerCosts, this.siegeCosts, this.otherCosts, this.otherIncome, this.donations, this.cash);
        }

        public String toString() {
            return "Treasury.TreasuryBuilder(currentHeadTaxValue=" + this.currentHeadTaxValue + ", currentPropertyTax=" + this.currentPropertyTax + ", paidTaxes=" + this.paidTaxes + ", paidSpecialTaxes=" + this.paidSpecialTaxes + ", cityGuardCosts=" + this.cityGuardCosts + ", buildingCosts=" + this.buildingCosts + ", outriggerCosts=" + this.outriggerCosts + ", siegeCosts=" + this.siegeCosts + ", otherCosts=" + this.otherCosts + ", otherIncome=" + this.otherIncome + ", donations=" + this.donations + ", cash=" + this.cash + ")";
        }
    }
}

