/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.model.city.CityProduction;
import ch.sahits.game.openpatrician.model.city.EPopulationClass;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.city.PopulationConsume;
import ch.sahits.game.openpatrician.model.city.impl.CityWall;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.factory.StateFactory;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import com.google.common.annotations.VisibleForTesting;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class CityState {
    @XStreamOmitField
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    @XStreamOmitField
    private Random rnd;
    @Value(value="${ware.surplus.treshold}")
    private double surplusThreshold;
    private ICity city;
    @MapType(key=IWare.class, value=Double.class)
    private Map<IWare, Double> consumed = new HashMap<IWare, Double>();
    @MapType(key=IWare.class, value=Double.class)
    private Map<IWare, Double> produced = new HashMap<IWare, Double>();
    @Autowired
    private CityProduction production;
    private TavernState tavernState = null;
    private IShipyard shipyardState = null;
    @Autowired
    private PopulationConsume consume;
    @Autowired
    @XStreamOmitField
    private StateFactory stateFactory;
    @Autowired
    private CityWall cityWall;

    public CityState(ICity city) {
        this.city = city;
    }

    @PostConstruct
    private void initCity() {
        EWare[] wares;
        if (this.shipyardState == null) {
            this.shipyardState = this.stateFactory.createShipYard(this.city);
        }
        for (EWare ware : wares = EWare.values()) {
            this.consumed.put(ware, 0.0);
            this.produced.put(ware, 0.0);
        }
        if (this.tavernState == null) {
            this.tavernState = this.stateFactory.createTavernState(this.city);
        }
        if (this.city.getCityState() == null) {
            this.city.setCityState(this);
        }
    }

    public void consumeWares() {
        EWare[] wares = EWare.values();
        EPopulationClass[] popClasses = EPopulationClass.values();
        for (EWare ware : wares) {
            double amount = this.consumed.get(ware);
            for (EPopulationClass popClass : popClasses) {
                amount += this.consume.getNeed(ware, popClass, this.city.getPopulation(popClass));
            }
            this.consumed.put(ware, amount);
        }
        for (Map.Entry entry : this.consumed.entrySet()) {
            if (!((Double)entry.getValue() >= 1.0)) continue;
            int whole = (int)Math.rint(Math.floor((Double)entry.getValue()));
            this.consumed.put((IWare)entry.getKey(), (Double)entry.getValue() - (double)whole);
            this.city.move((IWare)entry.getKey(), -whole, null);
        }
    }

    public void produceWares() {
        double amount;
        IWare[] wares = this.city.getEffectiveProduction();
        for (IWare ware : wares) {
            amount = this.produced.get(ware);
            this.produced.put(ware, amount += (double)this.production.getEfficientProduction(ware) / 14.0);
        }
        wares = this.city.getIneffectiveProduction();
        for (IWare ware : wares) {
            amount = this.produced.get(ware);
            this.produced.put(ware, amount += (double)this.production.getInefficientProduction(ware) / 14.0);
        }
        for (Map.Entry entry : this.produced.entrySet()) {
            if (!((Double)entry.getValue() >= 1.0)) continue;
            int whole = (int)Math.rint(Math.floor((Double)entry.getValue()));
            this.produced.put((IWare)entry.getKey(), (Double)entry.getValue() - (double)whole);
            this.city.move((IWare)entry.getKey(), whole, null);
        }
    }

    public Optional<IWare> findMostNeededWare() {
        Map<IWare, DateTime> missing = this.city.getMissingWares();
        DateTime earliest = null;
        IWare result = null;
        for (Map.Entry<IWare, DateTime> entry : missing.entrySet()) {
            if (earliest != null && !entry.getValue().isBefore((ReadableInstant)earliest)) continue;
            earliest = entry.getValue();
            result = entry.getKey();
        }
        if (result == null) {
            Map<IWare, Integer> available = this.getSortedWareAvailabilityMap();
            IWare wareRunninOutFirst = null;
            int runsOutInDays = Integer.MAX_VALUE;
            for (Map.Entry<IWare, Integer> entry : available.entrySet()) {
                int days;
                IWare ware = entry.getKey();
                double consumptionPerWeek = this.consume.getWeeklyConsumption(ware, this.city);
                double productionPerWeek = this.production.getProduction(ware);
                double dailyConsumtion = (productionPerWeek - consumptionPerWeek) / 7.0;
                if (dailyConsumtion >= 0.0 || (days = -((int)((double)entry.getValue().intValue() / dailyConsumtion))) >= runsOutInDays) continue;
                runsOutInDays = days;
                wareRunninOutFirst = ware;
            }
            result = wareRunninOutFirst;
        }
        return Optional.ofNullable(result);
    }

    public Optional<IWare> findWareWithMostSurplus() {
        ArrayList<EWare> surplus = new ArrayList<EWare>();
        for (EWare ware : EWare.values()) {
            AmountablePrice<IWare> amount = this.city.getWare(ware);
            double actualPrice = amount.getAVGPrice();
            int minPrice = ware.getMinValueSell();
            double val = (double)minPrice / actualPrice - 1.0;
            if (!(val <= this.surplusThreshold)) continue;
            surplus.add(ware);
        }
        if (surplus.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(surplus.get(this.rnd.nextInt(surplus.size())));
    }

    @VisibleForTesting
    Map<IWare, Integer> getSortedWareAvailabilityMap() {
        Comparator<IWare> comparator = new Comparator<IWare>(){

            @Override
            public int compare(IWare ware1, IWare ware2) {
                return CityState.this.city.getWare(ware1).getAmount() - CityState.this.city.getWare(ware2).getAmount();
            }
        };
        TreeMap<IWare, Integer> map = new TreeMap<IWare, Integer>(comparator);
        for (EWare ware : EWare.values()) {
            map.put(ware, this.city.getWare(ware).getAmount());
        }
        map.size();
        return map;
    }

    public ICity getCity() {
        return this.city;
    }

    public TavernState getTavernState() {
        return this.tavernState;
    }

    public IShipyard getShipyardState() {
        return this.shipyardState;
    }

    public CityWall getCityWall() {
        return this.cityWall;
    }

    public void setCityWall(CityWall cityWall) {
        this.cityWall = cityWall;
    }
}

