/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.ILoanRequest;
import ch.sahits.game.openpatrician.model.city.ILoaner;
import ch.sahits.game.openpatrician.model.city.impl.IDebt;
import ch.sahits.game.openpatrician.model.city.impl.ILoanProposal;
import ch.sahits.game.openpatrician.model.city.impl.LoanProposal;
import ch.sahits.game.openpatrician.model.city.impl.LoanRequest;
import ch.sahits.game.openpatrician.model.impl.Citizen;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class LoanerState
implements ILoaner {
    private static final int MAX_WEEKS_FOR_REQUEST = 4;
    private static final int MAX_REQUESTS = 6;
    private static final int MAX_LOAN_PROPOSAL = 3;
    private final ICity city;
    @ListType(value=IDebt.class)
    private List<IDebt> debts = new ArrayList<IDebt>();
    @ListType(value=ILoanRequest.class)
    private List<ILoanRequest> requests = new ArrayList<ILoanRequest>();
    @ListType(value=ILoanProposal.class)
    private List<ILoanProposal> loanProposals = new ArrayList<ILoanProposal>();
    @Autowired
    private Date date;
    @Autowired
    @XStreamOmitField
    private Random rnd;
    private static RandomNameLoader firstNameLoader = new RandomNameLoader("firstnames.properties");
    private static RandomNameLoader lastNameLoader = new RandomNameLoader("lastnames.properties");

    public LoanerState(ICity city) {
        this.city = city;
    }

    @Override
    public void update() {
        this.clearOldRequests();
        while (this.requests.size() < 6) {
            this.createNewLoanRequest();
        }
        while (this.loanProposals.size() < 3) {
            this.createNewLoanProposal();
        }
    }

    private void createNewLoanProposal() {
        int duration = this.rnd.nextInt(30) + 5;
        double interesst = this.rnd.nextDouble() + 1.0;
        interesst = interesst / 100.0 + 1.0;
        int amount = this.rnd.nextInt(2500) * 10 + 5000;
        LoanProposal proposal = LoanProposal.builder().amount(amount).durationInWeeks(duration).interest(interesst).build();
        this.loanProposals.add(proposal);
    }

    private void createNewLoanRequest() {
        DateTime now = this.date.getCurrentDate();
        int duration = this.rnd.nextInt(50) + 10;
        int rankIndexBound = ESocialRank.values().length - 2;
        int rankIndex = this.rnd.nextInt(rankIndexBound);
        ESocialRank rank = ESocialRank.values()[rankIndex];
        Citizen citizen = new Citizen(lastNameLoader.getRandomName(), firstNameLoader.getRandomName(), rank, this.city);
        int amount = (this.rnd.nextInt(10000) + 1000) * (rankIndex + 1);
        LoanRequest request = LoanRequest.builder().citizen(citizen).durationInWeeks(duration).issued(now).sum(amount).build();
        this.requests.add(request);
    }

    private void clearOldRequests() {
        DateTime now = this.date.getCurrentDate();
        DateTime before4Weeks = now.minusWeeks(4);
        Iterator<ILoanRequest> iterator = this.requests.iterator();
        while (iterator.hasNext()) {
            ILoanRequest request = iterator.next();
            if (!request.issued().isBefore((ReadableInstant)before4Weeks)) continue;
            iterator.remove();
        }
    }

    @Override
    public void addDebt(IDebt debt) {
        DateTime now = this.date.getCurrentDate();
        Preconditions.checkArgument((boolean)debt.getDueDate().isAfter((ReadableInstant)now));
        this.debts.add(debt);
    }

    @Override
    public ICity getCity() {
        return this.city;
    }

    @Override
    public List<IDebt> getDebts() {
        return this.debts;
    }

    @Override
    public List<ILoanRequest> getRequests() {
        return this.requests;
    }

    @Override
    public List<ILoanProposal> getLoanProposals() {
        return this.loanProposals;
    }
}

