/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.IBuyer;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.people.IConcurrent;
import ch.sahits.game.openpatrician.model.people.IContractBroker;
import ch.sahits.game.openpatrician.model.people.ICourier;
import ch.sahits.game.openpatrician.model.people.IEscorte;
import ch.sahits.game.openpatrician.model.people.IFugitive;
import ch.sahits.game.openpatrician.model.people.IInformant;
import ch.sahits.game.openpatrician.model.people.IPatrol;
import ch.sahits.game.openpatrician.model.people.IPerson;
import ch.sahits.game.openpatrician.model.people.IPirate;
import ch.sahits.game.openpatrician.model.people.IPirateHunter;
import ch.sahits.game.openpatrician.model.people.ISailorState;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.people.ISmuggler;
import ch.sahits.game.openpatrician.model.people.ITavernPerson;
import ch.sahits.game.openpatrician.model.people.IThieve;
import ch.sahits.game.openpatrician.model.people.ITrader;
import ch.sahits.game.openpatrician.model.people.ITransportTrader;
import ch.sahits.game.openpatrician.model.people.ITraveler;
import ch.sahits.game.openpatrician.model.people.ITreasureMapOwner;
import ch.sahits.game.openpatrician.model.people.IWarehouseTenant;
import ch.sahits.game.openpatrician.model.people.IWeaponsDealer;
import ch.sahits.game.openpatrician.model.people.impl.CaptainsState;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.MapProperty;
import javafx.beans.property.SimpleMapProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class TavernState {
    @Autowired
    private ITrader trader;
    @Autowired
    private IInformant informant;
    @Autowired
    private ITraveler traveler;
    private IContractBroker contractBrooker;
    @Autowired
    private IThieve thieve;
    @Autowired
    private IEscorte escorte;
    @Autowired
    private IFugitive fugative;
    @Autowired
    private IPatrol patrol;
    @Autowired
    private ICourier courier;
    @Autowired
    private ITransportTrader transportTrader;
    @Autowired
    private IConcurrent concurrent;
    @Autowired
    private IBuyer buyer;
    @Autowired
    private IPirateHunter pirateHunter;
    @Autowired
    private IWarehouseTenant warehouseTenant;
    @Autowired
    private ISmuggler smuggler;
    @Autowired
    private ITreasureMapOwner treasureMap;
    @Autowired
    private IWeaponsDealer weaponsDealer;
    @Autowired
    private IPirate pirate;
    @Autowired
    private ISailorState sailors;
    @Autowired
    private CaptainsState captainsState;
    private ICity city;
    @ListType(value=ITavernPerson.class)
    private ObservableList<ITavernPerson> absentPersons;
    @ListType(value=IPerson.class)
    private ObservableList<IPerson> presentPersons;
    private ObjectBinding<List<ISideRoomPerson>> presentPersonsInSideRoom;
    @MapType(key=IPerson.class, value=IPerson.class)
    private MapProperty<IPerson, IPlayer> talkingTo;
    @ListType(value=ISideRoomPerson.class)
    private final List<ISideRoomPerson> sideRoomPersons = Lists.newArrayList();

    public TavernState(ICity city) {
        this.city = city;
        this.talkingTo = new SimpleMapProperty((Object)this, "talkingTo");
        this.talkingTo.set((Object)FXCollections.observableMap(new HashMap()));
    }

    public ObservableList<ITavernPerson> absentPersonProperty() {
        return this.absentPersons;
    }

    public ObservableList<IPerson> presentPersonsProperty() {
        return this.presentPersons;
    }

    public ObjectBinding<List<ISideRoomPerson>> presentPersonsInSideRoomBinding() {
        return this.presentPersonsInSideRoom;
    }

    public ISailorState getSailors() {
        return this.sailors;
    }

    private void initCity() {
        this.buyer.setCity(this.city);
        this.concurrent.setCity(this.city);
        this.courier.setCity(this.city);
        this.escorte.setCity(this.city);
        this.fugative.setCity(this.city);
        this.informant.setCity(this.city);
        this.patrol.setCity(this.city);
        this.pirate.setCity(this.city);
        this.pirateHunter.setCity(this.city);
        this.smuggler.setCity(this.city);
        this.thieve.setCity(this.city);
        this.trader.setCity(this.city);
        this.transportTrader.setCity(this.city);
        this.traveler.setCity(this.city);
        this.treasureMap.setCity(this.city);
        this.warehouseTenant.setCity(this.city);
        this.presentPersons.addAll(this.getPresentPersons());
    }

    @PostConstruct
    private void initializePresenceBinding() {
        ObservableList absentList = FXCollections.observableList(this.getAbsentPersons());
        this.absentPersons = FXCollections.synchronizedObservableList((ObservableList)absentList);
        ObservableList syncBackingPresentList = FXCollections.observableArrayList();
        this.presentPersons = FXCollections.synchronizedObservableList((ObservableList)syncBackingPresentList);
        this.sideRoomPersons.add(this.courier);
        this.sideRoomPersons.add(this.transportTrader);
        this.sideRoomPersons.add(this.thieve);
        this.sideRoomPersons.add(this.escorte);
        this.sideRoomPersons.add(this.fugative);
        this.sideRoomPersons.add(this.patrol);
        this.sideRoomPersons.add(this.concurrent);
        this.sideRoomPersons.add(this.buyer);
        this.sideRoomPersons.add(this.pirateHunter);
        this.sideRoomPersons.add(this.warehouseTenant);
        this.sideRoomPersons.add(this.smuggler);
        this.sideRoomPersons.add(this.treasureMap);
        for (ISideRoomPerson sideRoomPerson : this.sideRoomPersons) {
            sideRoomPerson.isPresentProperty().addListener((ChangeListener)new PresenceChangeListener(sideRoomPerson));
        }
        this.trader.isPresentProperty().addListener((ChangeListener)new PresenceChangeListener(this.trader));
        this.informant.isPresentProperty().addListener((ChangeListener)new PresenceChangeListener(this.informant));
        this.traveler.isPresentProperty().addListener((ChangeListener)new PresenceChangeListener(this.traveler));
        this.pirate.isPresentProperty().addListener((ChangeListener)new PresenceChangeListener(this.pirate));
        this.presentPersonsInSideRoom = new ObjectBinding<List<ISideRoomPerson>>(){
            {
                for (ISideRoomPerson sideRoomPerson : TavernState.this.sideRoomPersons) {
                    super.bind(new Observable[]{sideRoomPerson.isPresentProperty()});
                }
            }

            protected List<ISideRoomPerson> computeValue() {
                ArrayList persons = Lists.newArrayList();
                for (ISideRoomPerson sideRoomPerson : TavernState.this.sideRoomPersons) {
                    if (!sideRoomPerson.isPresent()) continue;
                    persons.add(sideRoomPerson);
                }
                return persons;
            }
        };
        this.initCity();
    }

    private List<ITavernPerson> getAbsentPersons() {
        List<ITavernPerson> tavernPerson = this.asListAllAbsent();
        ArrayList<ITavernPerson> allAbsent = new ArrayList<ITavernPerson>();
        if (!this.pirate.isPresent()) {
            allAbsent.add(this.pirate);
        }
        for (int i = 0; i < tavernPerson.size(); ++i) {
            allAbsent.add(tavernPerson.get(i));
        }
        return Collections.synchronizedList(allAbsent);
    }

    private List<IPerson> getPresentPersons() {
        Preconditions.checkNotNull((Object)this.city);
        List<IPerson> tavernPerson = this.asListAllPresent();
        ArrayList<IPerson> allPresent = new ArrayList<IPerson>();
        int index = 0;
        if (!tavernPerson.isEmpty() && tavernPerson.get(index) instanceof IContractBroker) {
            allPresent.add(tavernPerson.get(index++));
        }
        allPresent.add(this.getSailors());
        Optional<ICaptain> captain = this.captainsState.getCaptain(this.city);
        if (captain.isPresent()) {
            allPresent.add(captain.get());
        }
        if (this.pirate.isPresent()) {
            allPresent.add(this.pirate);
        }
        allPresent.add(this.getWeaponsDealer());
        for (int i = index; i < tavernPerson.size(); ++i) {
            allPresent.add(tavernPerson.get(i));
        }
        return allPresent;
    }

    public void setContractBrooker(IContractBroker contractBrooker) {
        this.contractBrooker = contractBrooker;
    }

    List<IPerson> asListAllPresent() {
        ArrayList<IPerson> list = new ArrayList<IPerson>();
        if (this.contractBrooker != null) {
            list.add(this.contractBrooker);
        }
        if (this.informant.isPresent()) {
            list.add(this.informant);
        }
        if (this.trader.isPresent()) {
            list.add(this.trader);
        }
        if (this.traveler.isPresent()) {
            list.add(this.traveler);
        }
        if (this.thieve.isPresent()) {
            list.add(this.thieve);
        }
        if (this.escorte.isPresent()) {
            list.add(this.escorte);
        }
        if (this.fugative.isPresent()) {
            list.add(this.fugative);
        }
        if (this.patrol.isPresent()) {
            list.add(this.patrol);
        }
        if (this.courier.isPresent()) {
            list.add(this.courier);
        }
        if (this.transportTrader.isPresent()) {
            list.add(this.transportTrader);
        }
        if (this.concurrent.isPresent()) {
            list.add(this.concurrent);
        }
        if (this.buyer.isPresent()) {
            list.add(this.buyer);
        }
        if (this.pirateHunter.isPresent()) {
            list.add(this.pirateHunter);
        }
        if (this.warehouseTenant.isPresent()) {
            list.add(this.warehouseTenant);
        }
        if (this.smuggler.isPresent()) {
            list.add(this.smuggler);
        }
        if (this.treasureMap.isPresent()) {
            list.add(this.treasureMap);
        }
        return list;
    }

    List<ITavernPerson> asListAllAbsent() {
        ArrayList<ITavernPerson> list = new ArrayList<ITavernPerson>();
        if (!this.informant.isPresent()) {
            list.add(this.informant);
        }
        if (!this.trader.isPresent()) {
            list.add(this.trader);
        }
        if (!this.traveler.isPresent()) {
            list.add(this.traveler);
        }
        if (!this.thieve.isPresent()) {
            list.add(this.thieve);
        }
        if (!this.escorte.isPresent()) {
            list.add(this.escorte);
        }
        if (!this.fugative.isPresent()) {
            list.add(this.fugative);
        }
        if (!this.patrol.isPresent()) {
            list.add(this.patrol);
        }
        if (!this.courier.isPresent()) {
            list.add(this.courier);
        }
        if (!this.transportTrader.isPresent()) {
            list.add(this.transportTrader);
        }
        if (!this.concurrent.isPresent()) {
            list.add(this.concurrent);
        }
        if (!this.buyer.isPresent()) {
            list.add(this.buyer);
        }
        if (!this.pirateHunter.isPresent()) {
            list.add(this.pirateHunter);
        }
        if (!this.warehouseTenant.isPresent()) {
            list.add(this.warehouseTenant);
        }
        if (!this.smuggler.isPresent()) {
            list.add(this.smuggler);
        }
        if (!this.treasureMap.isPresent()) {
            list.add(this.treasureMap);
        }
        return list;
    }

    public MapProperty<IPerson, IPlayer> talkingToProperty() {
        return this.talkingTo;
    }

    public boolean isTalkingToOtherPlayer(ITavernPerson person, IPlayer player) {
        if (((ObservableMap)this.talkingTo.get()).containsKey((Object)person)) {
            return !player.equals(((ObservableMap)this.talkingTo.get()).get((Object)person));
        }
        return false;
    }

    public ITrader getTrader() {
        return this.trader;
    }

    public IInformant getInformant() {
        return this.informant;
    }

    public ITraveler getTraveler() {
        return this.traveler;
    }

    public IContractBroker getContractBrooker() {
        return this.contractBrooker;
    }

    public IThieve getThieve() {
        return this.thieve;
    }

    public IEscorte getEscorte() {
        return this.escorte;
    }

    public IFugitive getFugative() {
        return this.fugative;
    }

    public IPatrol getPatrol() {
        return this.patrol;
    }

    public ICourier getCourier() {
        return this.courier;
    }

    public ITransportTrader getTransportTrader() {
        return this.transportTrader;
    }

    public IConcurrent getConcurrent() {
        return this.concurrent;
    }

    public IBuyer getBuyer() {
        return this.buyer;
    }

    public IPirateHunter getPirateHunter() {
        return this.pirateHunter;
    }

    public IWarehouseTenant getWarehouseTenant() {
        return this.warehouseTenant;
    }

    public ISmuggler getSmuggler() {
        return this.smuggler;
    }

    public ITreasureMapOwner getTreasureMap() {
        return this.treasureMap;
    }

    public IWeaponsDealer getWeaponsDealer() {
        return this.weaponsDealer;
    }

    public IPirate getPirate() {
        return this.pirate;
    }

    public CaptainsState getCaptainsState() {
        return this.captainsState;
    }

    private class PresenceChangeListener
    implements ChangeListener<Boolean> {
        private final ITavernPerson tavernPerson;

        private PresenceChangeListener(ITavernPerson tavernPerson) {
            this.tavernPerson = tavernPerson;
        }

        public void changed(ObservableValue<? extends Boolean> observableValue, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue()) {
                TavernState.this.absentPersons.remove((Object)this.tavernPerson);
                TavernState.this.presentPersons.add((Object)this.tavernPerson);
            } else {
                TavernState.this.presentPersons.remove((Object)this.tavernPerson);
                TavernState.this.absentPersons.addAll((Object[])new ITavernPerson[]{this.tavernPerson});
            }
        }
    }
}

