/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IBalanceSheet;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.IAutomatedTrading;
import ch.sahits.game.openpatrician.model.building.IBuilding;
import ch.sahits.game.openpatrician.model.building.ISteward;
import ch.sahits.game.openpatrician.model.building.IStorage;
import ch.sahits.game.openpatrician.model.building.ITownHouse;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.building.IWorkShop;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.time.PeriodicalTimeUpdaterV2;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class BalanceSheet
implements IBalanceSheet {
    private final ICity city;
    private final IPlayer player;
    @Autowired
    private Date gameDate;
    @XStreamOmitField
    private PeriodicalTimeUpdaterV2 updater;
    private int rentalIncome;
    private int[] rentalIncomeDays;
    private int wageCosts;
    private int[] wageCostsDays;
    private int propertyTaxes;
    private int officeTrading;
    private int[] officeTradingDays;
    private int stewardCost;
    private int[] stewardCostsDays;
    private int otherCosts;
    private int[] otherCostsDays;

    public BalanceSheet(ICity city, IPlayer player) {
        this.city = city;
        this.player = player;
        this.rentalIncome = 0;
        this.rentalIncomeDays = new int[]{0, 0, 0, 0, 0, 0, 0};
        this.wageCosts = 0;
        this.wageCostsDays = new int[]{0, 0, 0, 0, 0, 0, 0};
        this.propertyTaxes = 0;
        this.officeTrading = 0;
        this.officeTradingDays = new int[]{0, 0, 0, 0, 0, 0, 0};
        this.stewardCost = 0;
        this.stewardCostsDays = new int[]{0, 0, 0, 0, 0, 0, 0};
        this.otherCosts = 0;
        this.otherCostsDays = new int[]{0, 0, 0, 0, 0, 0, 0};
    }

    public BalanceSheet(BalanceSheet prevWeek) {
        this.city = prevWeek.city;
        this.player = prevWeek.player;
        this.rentalIncome = prevWeek.rentalIncomeDays[6] * 7;
        this.rentalIncomeDays = new int[]{prevWeek.rentalIncomeDays[6], prevWeek.rentalIncomeDays[6], prevWeek.rentalIncomeDays[6], prevWeek.rentalIncomeDays[6], prevWeek.rentalIncomeDays[6], prevWeek.rentalIncomeDays[6], prevWeek.rentalIncomeDays[6]};
        this.wageCosts = prevWeek.wageCostsDays[6] * 7;
        this.wageCostsDays = new int[]{prevWeek.wageCostsDays[6], prevWeek.wageCostsDays[6], prevWeek.wageCostsDays[6], prevWeek.wageCostsDays[6], prevWeek.wageCostsDays[6], prevWeek.wageCostsDays[6], prevWeek.wageCostsDays[6]};
        this.officeTrading = prevWeek.officeTradingDays[6] * 7;
        this.officeTradingDays = new int[]{prevWeek.officeTradingDays[6], prevWeek.officeTradingDays[6], prevWeek.officeTradingDays[6], prevWeek.officeTradingDays[6], prevWeek.officeTradingDays[6], prevWeek.officeTradingDays[6], prevWeek.officeTradingDays[6]};
        this.stewardCost = prevWeek.stewardCostsDays[6] * 7;
        this.stewardCostsDays = new int[]{prevWeek.stewardCostsDays[6], prevWeek.stewardCostsDays[6], prevWeek.stewardCostsDays[6], prevWeek.stewardCostsDays[6], prevWeek.stewardCostsDays[6], prevWeek.stewardCostsDays[6], prevWeek.stewardCostsDays[6]};
        this.otherCosts = prevWeek.otherCosts;
        this.otherCostsDays = new int[]{prevWeek.otherCosts / 7, prevWeek.otherCosts / 7, prevWeek.otherCosts / 7, prevWeek.otherCosts / 7, prevWeek.otherCosts / 7, prevWeek.otherCosts / 7, prevWeek.otherCosts / 7};
    }

    /*
     * WARNING - void declaration
     */
    public void handleDailyUpdate() {
        void var11_30;
        void var8_12;
        ITradingOffice office = this.player.findTradingOffice(this.city);
        int weekIndex = this.gameDate.getCurrentDate().getDayOfWeek();
        ISteward steward = office.getSteward();
        int dailyCost = 0;
        if (steward != null) {
            dailyCost = (int)Math.rint((double)steward.getSalary() / 7.0);
        }
        for (int i = weekIndex; i < this.stewardCostsDays.length; ++i) {
            this.stewardCostsDays[i] = dailyCost;
        }
        int sum = 0;
        int[] nArray = this.stewardCostsDays;
        int n = nArray.length;
        boolean bl = false;
        while (var8_12 < n) {
            int cost = nArray[var8_12];
            sum += cost;
            ++var8_12;
        }
        this.stewardCost = sum;
        List<ITownHouse> townHouses = this.player.findBuildings(this.city, ITownHouse.class);
        dailyCost = 0;
        for (IBuilding iBuilding : townHouses) {
            dailyCost += ((ITownHouse)iBuilding).computeRentalIncome();
        }
        for (int i = weekIndex; i < this.rentalIncomeDays.length; ++i) {
            this.rentalIncomeDays[i] = dailyCost;
        }
        sum = 0;
        for (int cost : this.rentalIncomeDays) {
            sum += cost;
        }
        this.rentalIncome = sum;
        List<IBuilding> buildings = this.player.findBuildings(this.city);
        dailyCost = 0;
        for (IBuilding building : buildings) {
            dailyCost += building.getPropertyTax();
        }
        List<IWorkShop> list = this.player.findBuildings(this.city, IWorkShop.class);
        IStorage storage = office.getStorage();
        dailyCost = 0;
        for (IBuilding iBuilding : list) {
            dailyCost += (int)Math.rint((double)((IWorkShop)iBuilding).getSalaryPerWorker() / 7.0);
        }
        for (int i = weekIndex; i < this.wageCostsDays.length; ++i) {
            this.wageCostsDays[i] = dailyCost + storage.guardCostsPerDayBinding().get();
        }
        sum = 0;
        for (int cost : this.wageCostsDays) {
            sum += cost;
        }
        this.wageCosts = sum;
        IAutomatedTrading automaticTrading = office.getOfficeTrading();
        if (automaticTrading == null) {
            void var11_27;
            int n2 = weekIndex;
            while (var11_27 < this.officeTradingDays.length) {
                this.officeTradingDays[var11_27] = 0;
                ++var11_27;
            }
        }
        sum = 0;
        for (int cost : this.officeTradingDays) {
            sum += cost;
        }
        this.officeTrading = sum;
        int n3 = weekIndex;
        while (var11_30 < this.otherCostsDays.length) {
            this.otherCostsDays[var11_30] = storage.costsPerDayBinding().get();
            ++var11_30;
        }
    }

    public void deductPropertyTaxes(int amount) {
        this.propertyTaxes = amount;
    }

    @Override
    public int getRentalIncome() {
        return this.rentalIncome;
    }

    @Override
    public int getWageCosts() {
        return this.wageCosts;
    }

    @Override
    public int getPropertyTaxes() {
        return this.propertyTaxes;
    }

    @Override
    public int getOfficeTrading() {
        return this.officeTrading;
    }

    @Override
    public int getStewardCost() {
        return this.stewardCost;
    }

    @Override
    public int getOtherCosts() {
        return this.otherCosts;
    }
}

