/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.impl;

import ch.sahits.game.event.data.PeriodicalTimeDayUpdate;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.IBuilding;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.CityFactory;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.javafx.IJavaFXApplicationThreadExecution;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.List;
import java.util.Set;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleLongProperty;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public final class Company
implements ICompany {
    private static final Logger logger = LogManager.getLogger(Company.class);
    private final IPlayer owner;
    private ICity homeTown;
    private long companyValue;
    private LongProperty cash;
    @Autowired
    @XStreamOmitField
    private CityFactory cityFactory;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @XStreamOmitField
    private IJavaFXApplicationThreadExecution threadExecutor;

    public Company(IPlayer owner, ICity homeTown, long cash) {
        this.owner = owner;
        this.homeTown = homeTown;
        this.cash = new SimpleLongProperty((Object)this, "cash", cash);
    }

    @PostConstruct
    private void initialzeUpdates() {
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.clientServerEventBus.unregister((Object)this);
    }

    @Subscribe
    public void handelDailyUpdates(PeriodicalTimeDayUpdate event) {
        this.companyValue = this.cash.get();
        List<IShip> ships = this.owner.getFleet();
        for (IShip ship : ships) {
            this.companyValue += (long)ship.getValue();
            Set<IWare> loaded = ship.getLoadedWares();
            for (IWare ware : loaded) {
                AmountablePrice<IWare> ap = ship.getWare(ware);
                this.companyValue += (long)(ap.getAVGPrice() * ap.getAmount());
            }
        }
        for (ICity city : this.cityFactory.getCities()) {
            List<IBuilding> buildings = this.owner.findBuildings(city);
            for (IBuilding building : buildings) {
                this.companyValue += (long)building.getValue();
                if (!(building instanceof ITradingOffice)) continue;
                ITradingOffice office = (ITradingOffice)building;
                for (EWare ware : EWare.values()) {
                    AmountablePrice<IWare> ap = office.getWare(ware);
                    this.companyValue += (long)(ap.getAVGPrice() * ap.getAmount());
                }
            }
        }
    }

    @Override
    public long getCash() {
        return this.cash.get();
    }

    @Override
    public void updateCash(long diff) {
        this.threadExecutor.execute(() -> this.cash.set(this.cash.get() + diff));
    }

    @Override
    public LongProperty cashProperty() {
        return this.cash;
    }

    @Override
    public ICity getHomeTown() {
        return this.homeTown;
    }

    @Override
    public long getCompanyValue() {
        return this.companyValue;
    }
}

