/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.ILandBridge;
import ch.sahits.game.openpatrician.model.IMap;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.IFutureTowns;
import ch.sahits.game.openpatrician.model.people.impl.CaptainsState;
import ch.sahits.game.openpatrician.model.sea.PirateNest;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javafx.geometry.Dimension2D;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
public class GameMap
implements IMap {
    @ListType(value=ICity.class)
    private final LinkedList<ICity> cities = new LinkedList();
    @Autowired
    private CaptainsState captainsState;
    private Dimension2D dimension;
    private String mapImagePath;
    @ListType(value=IFutureTowns.class)
    private final List<IFutureTowns> futureTowns = new ArrayList<IFutureTowns>();
    @ListType(value=ILandBridge.class)
    private final List<ILandBridge> landbridges = new ArrayList<ILandBridge>();
    @ListType(value=PirateNest.class)
    private final List<PirateNest> pirateNests = new ArrayList<PirateNest>();

    public void setup(Date date, Collection<ICity> cities, Dimension2D dim, String mapName) {
        this.dimension = dim;
        this.mapImagePath = mapName;
        for (ICity city : cities) {
            this.cities.add(city);
        }
        this.captainsState.init(this);
    }

    @Override
    public int getNumberCities() {
        return this.cities.size();
    }

    @Override
    public List<ICity> getCities() {
        return Collections.unmodifiableList(this.cities);
    }

    @Override
    public ICity findCity(String cityName) {
        for (ICity city : this.cities) {
            if (!city.getUniqueID().equals(cityName)) continue;
            return city;
        }
        return null;
    }

    public void setCaptainsState(CaptainsState captainsState) {
        this.captainsState = captainsState;
    }

    @Override
    public Dimension2D getDimension() {
        return this.dimension;
    }

    @Override
    public String getMapImagePath() {
        return this.mapImagePath;
    }

    @Override
    public List<IFutureTowns> getFutureTowns() {
        return this.futureTowns;
    }

    @Override
    public List<ILandBridge> getLandbridges() {
        return this.landbridges;
    }

    @Override
    public List<PirateNest> getPirateNests() {
        return this.pirateNests;
    }
}

