/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.impl;

import ch.sahits.game.openpatrician.collections.NonReplacableMap;
import ch.sahits.game.openpatrician.javafx.bindings.LateIntegerBinding;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javafx.beans.Observable;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;

public abstract class WareHolding {
    final NonReplacableMap<IWare, AmountablePrice<IWare>> wares = new NonReplacableMap();
    private final IntegerProperty occupiedSpace = new SimpleIntegerProperty(0);
    @XStreamOmitField
    private LateIntegerBinding storedAmountBinding = null;

    protected void addNewWare(IWare ware, int amount) {
        Preconditions.checkState((!this.containsWare(ware) ? 1 : 0) != 0, (Object)("Ware (" + ware.name() + ") does already exist"));
        AmountablePrice amountable = new AmountablePrice();
        amountable.add(amount, 0);
        this.wares.put((Object)ware, amountable);
        this.bindStoredAmount(amountable.amountProperty());
    }

    protected void bindStoredAmount(IntegerProperty amountProperty) {
        this.storedAmountBinding().bind((Observable)amountProperty);
    }

    protected void unbindAllAmounts() {
        for (AmountablePrice amountablePrice : this.wares.values()) {
            this.storedAmountBinding().unbind((Observable)amountablePrice.amountProperty());
        }
    }

    public AmountablePrice<IWare> getWare(IWare ware) {
        if (!this.containsWare(ware)) {
            this.addNewWare(ware, 0);
        }
        AmountablePrice ret = (AmountablePrice)this.wares.get((Object)ware);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int move(IWare ware, int amount, ICitizen player) {
        IWare iWare = ware;
        synchronized (iWare) {
            AmountablePrice<IWare> amounted = this.getWare(ware);
            if (amount < 0 && this.containsWare(ware) && amounted != null && -amount > amounted.getAmount()) {
                amount = -amounted.getAmount();
            }
            if (amount < 0 && !this.containsWare(ware)) {
                amount = 0;
            }
            if (!this.containsWare(ware)) {
                new IllegalStateException("All wares should be initialized, allowed in test").printStackTrace();
            }
            if (amount > 0) {
                amounted.add(amount, this.computeAVGPrice(ware, amount));
            } else {
                amounted.remove(amount);
            }
            return amount;
        }
    }

    protected final boolean containsWare(IWare ware) {
        return this.wares.containsKey((Object)ware);
    }

    protected int computeAVGPrice(IWare ware, int amount) {
        int available = this.getWare(ware).getAmount();
        return ware.computeSellPrice(available, amount);
    }

    private int internalStoredAmountCalculation() {
        EWare[] wares;
        int totalAmount = 0;
        for (EWare ware : wares = EWare.values()) {
            AmountablePrice<IWare> amount = this.getWare(ware);
            if (amount == null) continue;
            totalAmount += amount.getAmount() * ware.getSizeAsBarrels();
        }
        return totalAmount;
    }

    public LateIntegerBinding storedAmountBinding() {
        if (this.storedAmountBinding == null) {
            this.storedAmountBinding = new LateIntegerBinding(){

                protected int computeValue() {
                    return WareHolding.this.internalStoredAmountCalculation();
                }
            };
        }
        return this.storedAmountBinding;
    }

    public IntegerProperty occupiedSpaceProperty() {
        return this.occupiedSpace;
    }

    public int getOccupiedSpace() {
        return this.occupiedSpace.get();
    }

    public void setOccupiedSpace(int occupiedSpace) {
        this.occupiedSpace.set(occupiedSpace);
    }
}

