/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.model.IUpdatableCityRelatedState;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.impl.BaseTavernPerson;
import ch.sahits.game.openpatrician.model.util.CityUtilities;
import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;

abstract class BaseTravelerState
extends BaseTavernPerson
implements IUpdatableCityRelatedState {
    private ICity destination;
    private int premium;
    @Autowired
    @XStreamOmitField
    private CityUtilities cityUtilities;
    @Autowired
    @XStreamOmitField
    private Random rnd;

    BaseTravelerState() {
    }

    @Override
    public void update(ICity city) {
        this.premium = this.rnd.nextInt(1543) + 324;
        this.destination = this.cityUtilities.findRandomCity(city);
        Preconditions.checkNotNull((Object)this.destination);
    }

    public ICity getDestination() {
        return this.destination;
    }

    public int getPremium() {
        return this.premium;
    }
}

