/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import java.beans.ConstructorProperties;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;

@ClassCategory(value={EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class CaptainTownMapping {
    private final ICity town;
    private final DateTime arrivalDate;
    private final ICaptain captain;

    public int getNumbersOfDaysInTown(Date currentDate) {
        DateTime now = currentDate.getCurrentDate();
        Duration duration = new Duration((ReadableInstant)this.arrivalDate, (ReadableInstant)now);
        return duration.toStandardDays().getDays();
    }

    @ConstructorProperties(value={"town", "arrivalDate", "captain"})
    public CaptainTownMapping(ICity town, DateTime arrivalDate, ICaptain captain) {
        this.town = town;
        this.arrivalDate = arrivalDate;
        this.captain = captain;
    }

    public ICity getTown() {
        return this.town;
    }

    public DateTime getArrivalDate() {
        return this.arrivalDate;
    }

    public ICaptain getCaptain() {
        return this.captain;
    }
}

